/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.gui;

import dev.buildtool.satako.Functions;
import dev.buildtool.satako.gui.Hideable;
import dev.buildtool.satako.gui.Positionable;
import dev.buildtool.satako.gui.Scrollable;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;

public class TextField
extends EditBox
implements Scrollable,
Positionable,
Hideable {
    public static final Predicate<String> POSITIVE_NUMBER = s -> s.isEmpty() || StringUtils.isNumeric((CharSequence)s);
    public boolean scrollable;
    private boolean enabled;
    protected int scrollAmount;

    public TextField(int X, int Y, Component text) {
        super(Minecraft.m_91087_().f_91062_, X, Y, Functions.calculateStringWidth(text) + 10, 15, text);
        this.scrollAmount = this.f_93619_;
        this.m_94164_(text.getString());
    }

    public TextField(int x, int y, Component string, int width) {
        this(x, y, string);
        this.m_93674_(width);
    }

    public TextField(int X, int Y, int width) {
        super(Minecraft.m_91087_().f_91062_, X, Y, width, 15, (Component)new TextComponent(""));
        this.scrollAmount = this.f_93619_;
    }

    public static TextField createWithMaxStringLength(int x_, int y_, int width, int maxStringLength, String string) {
        TextField textField = new TextField(x_, y_, width);
        textField.m_94199_(maxStringLength);
        textField.m_94164_(string);
        return textField;
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (this.scrollable) {
            if (vertical) {
                this.f_93620_ += amount;
            } else {
                this.f_93621_ += amount;
            }
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        this.scrollable = b;
    }

    @Override
    public void setEnabled() {
        this.enabled = true;
    }

    @Override
    public void setDisabled() {
        this.enabled = false;
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollAmount = pixels;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    @Override
    public int getX() {
        return this.f_93620_;
    }

    public void m_94214_(int X) {
        this.f_93620_ = X;
    }

    @Override
    public int getY() {
        return this.f_93621_;
    }

    @Override
    public void setY(int Y) {
        this.f_93621_ = Y;
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    @Override
    public void setHidden() {
        this.m_94194_(false);
    }

    @Override
    public void setVisible() {
        this.m_94194_(true);
    }
}

