/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FTBChunksHandler
implements ISelectiveResourceReloadListener {
    private static FTBChunksHandler INSTANCE = new FTBChunksHandler();
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");
    private static Entity currentEntity = null;
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    public static ResourceLocation villagerTexture = new ResourceLocation("ftbchunks", "textures/faces/minecraft/villager.png");
    private static Supplier<InputStream> defaultVillagerResource = null;

    public static void setCurrentEntity(Entity entity) {
        Minecraft mc;
        currentEntity = entity;
        if (entity instanceof VillagerEntity && (mc = Minecraft.func_71410_x()).func_110434_K().func_229267_b_(villagerTexture) != null) {
            mc.execute(() -> mc.func_110434_K().func_147645_c(villagerTexture));
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        FTBChunksHandler.setupDynamicIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        int innerSize;
        Markers.MarkerResource resource = resourceSupplier.get();
        if (resource == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconCache.containsKey(resource)) {
            return new ByteArrayInputStream(iconCache.get(resource));
        }
        int outerSize = innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        BufferedImage newImage = new BufferedImage(outerSize, outerSize, 2);
        Graphics2D graphics = newImage.createGraphics();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (!manager.func_219533_b(resource.texture) && Minecraft.func_71410_x().func_110434_K().func_229267_b_(resource.texture) == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconOverlayImage == null) {
            iconOverlayImage = ImageIO.read(manager.func_199002_a(Markers.ICON_OVERLAY).func_199027_b());
        }
        if (numberOverlayImage == null) {
            numberOverlayImage = ImageIO.read(manager.func_199002_a(Markers.NUMBER_OVERLAY).func_199027_b());
        }
        BufferedImage originalImage = ImageIO.read(manager.func_199002_a(resource.texture).func_199027_b());
        int left = (outerSize - innerSize) / 2;
        int right = (outerSize + innerSize) / 2;
        int top = (outerSize + innerSize) / 2;
        int bottom = (outerSize - innerSize) / 2;
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
        graphics.transform(at);
        graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            BufferedImage overlayImage = resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
            float scale = (float)innerSize / (float)originalImage.getWidth();
            graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
        });
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)newImage, "png", os);
            iconCache.put(resource, os.toByteArray());
            byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                iconCache.put(resource, new byte[0]);
                return Markers.getEmptyInputStream();
            }
        }
        os.close();
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager manager = mc.func_195551_G();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadableManager = (SimpleReloadableResourceManager)manager;
            if (!reloadableManager.field_199015_d.contains(INSTANCE)) {
                reloadableManager.field_199015_d.add(0, INSTANCE);
            }
            if (defaultVillagerResource == null) {
                try {
                    for (IResource resource : reloadableManager.func_199004_b(villagerTexture)) {
                        if (resource.func_199026_d().contentEquals("dynamicicons")) continue;
                        byte[] defaultVillagerBytes = IOUtils.toByteArray((InputStream)resource.func_199027_b());
                        defaultVillagerResource = () -> new ByteArrayInputStream(defaultVillagerBytes);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dynamicPack.registerResource(ResourcePackType.CLIENT_RESOURCES, villagerTexture, () -> {
                if (currentEntity == null || currentEntity instanceof VillagerEntity && ((VillagerEntity)currentEntity).func_70631_g_()) {
                    return Markers.getEmptyInputStream();
                }
                try {
                    String profession = Markers.getProfessionName(currentEntity);
                    int level = Markers.getProfessionLevel(currentEntity);
                    if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
                        return defaultVillagerResource == null ? Markers.getEmptyInputStream() : defaultVillagerResource.get();
                    }
                    InputStream proxyStream = FTBChunksHandler.getResizedIcon(() -> Markers.getMarkerResource(mc, profession, level));
                    Thread.sleep(1L);
                    if (proxyStream.available() == 0) {
                        return reloadableManager.func_199002_a(Markers.getMarkerResource((Minecraft)mc, (String)profession, (int)level).texture).func_199027_b();
                    }
                    return proxyStream;
                }
                catch (Exception e) {
                    return Markers.getEmptyInputStream();
                }
            });
            if (!reloadableManager.func_230232_b_().anyMatch(pack -> pack.equals(dynamicPack))) {
                reloadableManager.func_199021_a((IResourcePack)dynamicPack);
            }
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            Markers.clearResourceCache();
            FTBChunksHandler.clearIconCache();
        }
    }
}

