/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.commons.lang3.exception.ExceptionUtils;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.minimap.XaeroMinimap;

public class XaeroMinimapHandler
implements ISelectiveResourceReloadListener {
    private static XaeroMinimapHandler INSTANCE = new XaeroMinimapHandler();
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer<?> entityRenderer, Entity entity) {
        String profession = Markers.getProfessionName(entity);
        int professionLevel = Markers.getProfessionLevel(entity);
        if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
            EntityIconDefinitions.buildVariantIdString((StringBuilder)stringBuilder, entityRenderer, (Entity)entity);
        } else {
            stringBuilder.append(profession).append("-").append(professionLevel);
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        XaeroMinimapHandler.setupDynamicIcons();
        if (XaeroMinimap.instance.getInterfaces() != null) {
            XaeroMinimap.instance.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        Markers.MarkerResource resource = resourceSupplier.get();
        if (resource == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconCache.containsKey(resource)) {
            return new ByteArrayInputStream(iconCache.get(resource));
        }
        int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
        int outerSize = 64;
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        BufferedImage newImage = new BufferedImage(64, 64, 2);
        Graphics2D graphics = newImage.createGraphics();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (!manager.func_219533_b(resource.texture) && Minecraft.func_71410_x().func_110434_K().func_229267_b_(resource.texture) == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconOverlayImage == null) {
            iconOverlayImage = ImageIO.read(manager.func_199002_a(Markers.ICON_OVERLAY).func_199027_b());
        }
        if (numberOverlayImage == null) {
            numberOverlayImage = ImageIO.read(manager.func_199002_a(Markers.NUMBER_OVERLAY).func_199027_b());
        }
        BufferedImage originalImage = ImageIO.read(manager.func_199002_a(resource.texture).func_199027_b());
        int left = (64 - innerSize) / 2;
        int right = (64 + innerSize) / 2;
        int top = (64 + innerSize) / 2;
        int bottom = (64 - innerSize) / 2;
        graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            BufferedImage overlayImage = resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
            float scale = (float)innerSize / (float)originalImage.getWidth();
            graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
        });
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)newImage, "png", os);
            iconCache.put(resource, os.toByteArray());
            byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                iconCache.put(resource, new byte[0]);
                return Markers.getEmptyInputStream();
            }
        }
        os.close();
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager manager = mc.func_195551_G();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadableManager = (SimpleReloadableResourceManager)manager;
            Supplier<Collection> delayedResources = () -> reloadableManager.func_199003_a("textures/entity/villager/markers", s -> s.endsWith(".png"));
            if (!reloadableManager.field_199015_d.contains(INSTANCE)) {
                reloadableManager.field_199015_d.add(0, INSTANCE);
            }
            if (((Boolean)MerchantMarkersConfig.INSTANCE.showOnMiniMap.get()).booleanValue()) {
                int minLevel;
                int maxLevel;
                if (!MerchantMarkersConfig.INSTANCE.showLevels()) {
                    maxLevel = 0;
                    minLevel = 0;
                } else {
                    minLevel = 0;
                    maxLevel = 15;
                }
                dynamicPack.registerResource(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    for (ResourceLocation marker : (Collection)delayedResources.get()) {
                        for (int i = minLevel; i <= maxLevel; ++i) {
                            String[] components = marker.func_110623_a().split("/");
                            String iconName = components[components.length - 1].replace(".png", "");
                            variants.addProperty(iconName + "-" + String.valueOf(i), "sprite:" + marker.func_110623_a().replace(".png", "-" + String.valueOf(i) + ".png"));
                        }
                    }
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "com.anthonyhilyard.merchantmarkers.compat.XaeroMinimapHandler.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
                for (ResourceLocation marker : delayedResources.get()) {
                    String[] components = marker.func_110623_a().split("/");
                    String iconName = components[components.length - 1].replace(".png", "");
                    for (int i = minLevel; i <= maxLevel; ++i) {
                        int level = i;
                        ResourceLocation markerLocation = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + marker.func_110623_a().replace(".png", "-" + String.valueOf(i) + ".png"));
                        if (mc.func_110434_K().func_229267_b_(markerLocation) != null) {
                            mc.execute(() -> mc.func_110434_K().func_147645_c(markerLocation));
                        }
                        dynamicPack.registerResource(ResourcePackType.CLIENT_RESOURCES, markerLocation, () -> {
                            try {
                                InputStream proxyStream = XaeroMinimapHandler.getResizedIcon(() -> Markers.getMarkerResource(mc, iconName, level));
                                if (proxyStream.available() == 0) {
                                    return reloadableManager.func_199002_a(Markers.getMarkerResource((Minecraft)mc, (String)iconName, (int)level).texture).func_199027_b();
                                }
                                return proxyStream;
                            }
                            catch (Exception e) {
                                return Markers.getEmptyInputStream();
                            }
                        });
                    }
                }
            } else {
                dynamicPack.registerResource(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    variants.addProperty("default", "model");
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "xaero.common.minimap.render.radar.EntityIconDefinitions.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
            }
            if (!reloadableManager.func_230232_b_().anyMatch(pack -> pack.equals(dynamicPack))) {
                reloadableManager.func_199021_a((IResourcePack)dynamicPack);
            }
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        Markers.clearResourceCache();
        XaeroMinimapHandler.clearIconCache();
    }
}

