/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.mixin;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.JMTexture;
import journeymap.client.render.texture.TextureImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.resources.IResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DrawEntityStep.class}, remap=false)
public class JourneyMapDrawEntityStepMixin {
    @Shadow
    Minecraft minecraft;
    @Shadow
    WeakReference<LivingEntity> entityLivingRef;
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static Map<Markers.MarkerResource, JMTexture> textureCache = new HashMap<Markers.MarkerResource, JMTexture>();

    @Redirect(method={"drawCreature"}, at=@At(value="INVOKE", target="Ljourneymap/client/render/draw/DrawUtil;drawEntity(Lcom/mojang/blaze3d/matrix/MatrixStack;DDDLjourneymap/client/render/texture/JMTexture;FFD)V", remap=false))
    private void drawEntity(MatrixStack matrixStack, double x, double y, double heading, JMTexture textureIn, float alpha, float scale, double rotation) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        JMTexture texture = textureIn;
        if (entityLiving instanceof AbstractVillagerEntity && !((AbstractVillagerEntity)entityLiving).func_70631_g_()) {
            String profession = Markers.getProfessionName((Entity)entityLiving);
            if (!((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
                int level = Markers.getProfessionLevel((Entity)entityLiving);
                Markers.MarkerResource markerResource = Markers.getMarkerResource(this.minecraft, profession, level);
                if (!textureCache.containsKey(markerResource)) {
                    textureCache.put(markerResource, (JMTexture)new TextureImpl(this.getMarkerImage(markerResource), true));
                }
                texture = textureCache.get(markerResource);
            }
        }
        DrawUtil.drawEntity((MatrixStack)matrixStack, (double)x, (double)y, (double)heading, (JMTexture)texture, (float)alpha, (float)scale, (double)rotation);
    }

    private BufferedImage getMarkerImage(Markers.MarkerResource resource) {
        int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
        int outerSize = 64;
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        BufferedImage newImage = new BufferedImage(64, 64, 2);
        Graphics2D graphics = newImage.createGraphics();
        if (!manager.func_219533_b(resource.texture) && Minecraft.func_71410_x().func_110434_K().func_229267_b_(resource.texture) == null) {
            return null;
        }
        try {
            if (iconOverlayImage == null) {
                iconOverlayImage = ImageIO.read(manager.func_199002_a(Markers.ICON_OVERLAY).func_199027_b());
            }
            if (numberOverlayImage == null) {
                numberOverlayImage = ImageIO.read(manager.func_199002_a(Markers.NUMBER_OVERLAY).func_199027_b());
            }
            BufferedImage originalImage = ImageIO.read(manager.func_199002_a(resource.texture).func_199027_b());
            int left = (64 - innerSize) / 2;
            int right = (64 + innerSize) / 2;
            int top = (64 + innerSize) / 2;
            int bottom = (64 - innerSize) / 2;
            AffineTransform at = new AffineTransform();
            at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
            at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
            graphics.transform(at);
            graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
            Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
                BufferedImage overlayImage = resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
                float scale = (float)innerSize / (float)originalImage.getWidth();
                graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
            });
            graphics.dispose();
        }
        catch (Exception e) {
            return null;
        }
        return newImage;
    }
}

