/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.util.NullInputStream;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class Markers {
    public static final ResourceLocation MARKER_ARROW = new ResourceLocation("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final ResourceLocation ICON_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final ResourceLocation NUMBER_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("merchantmarkers", "textures/entity/villager/default.png");
    public static final ResourceLocation EMPTY_MARKER = new ResourceLocation("merchantmarkers", "textures/entity/villager/empty.png");
    private static Supplier<InputStream> emptyMarkerResource = null;
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static InputStream getEmptyInputStream() {
        if (emptyMarkerResource == null) {
            emptyMarkerResource = () -> {
                Minecraft mc = Minecraft.func_71410_x();
                IResourceManager manager = mc.func_195551_G();
                try {
                    return manager.func_199002_a(EMPTY_MARKER).func_199027_b();
                }
                catch (Exception e) {
                    return NullInputStream.stream();
                }
            };
        }
        return emptyMarkerResource.get();
    }

    public static String getProfessionName(Entity entity) {
        String iconName = "default";
        iconName = entity instanceof VillagerEntity ? ((VillagerEntity)entity).func_213700_eh().func_221130_b().toString().replace(":", "__") : (entity instanceof WanderingTraderEntity ? "wandering_trader" : entity.getClass().getName().toLowerCase());
        return iconName;
    }

    public static int getProfessionLevel(Entity entity) {
        int level = 0;
        if (MerchantMarkersConfig.INSTANCE.showLevels() && entity instanceof VillagerEntity) {
            level = ((VillagerEntity)entity).func_213700_eh().func_221132_c();
        }
        return level;
    }

    public static void renderMarker(EntityRenderer<?> renderer, Entity entity, ITextComponent component, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (entity instanceof AbstractVillagerEntity) {
            double maxDistance;
            Minecraft mc = Minecraft.func_71410_x();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
                return;
            }
            double squareDistance = renderer.field_76990_c.func_229099_b_(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.INSTANCE.maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.INSTANCE.fadePercent.get();
            float currentAlpha = 1.0f;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = (float)MathHelper.func_151237_a((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
            }
            float entityHeight = entity.func_213302_cg() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.INSTANCE.verticalOffset.get()).intValue();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)entityHeight, 0.0);
            matrixStack.func_227863_a_(renderer.field_76990_c.func_229098_b_());
            matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
            boolean blendEnabled = GL11.glIsEnabled((int)3042);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            boolean showArrow = (Boolean)MerchantMarkersConfig.INSTANCE.showArrow.get();
            if (((Boolean)MerchantMarkersConfig.INSTANCE.showThroughWalls.get()).booleanValue()) {
                RenderSystem.disableDepthTest();
                Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), matrixStack, -8, showArrow ? y - 9 : y, 0.3f * currentAlpha);
                if (showArrow) {
                    Markers.renderArrow(matrixStack, 0, y, 0.3f * currentAlpha);
                }
            }
            RenderSystem.enableDepthTest();
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), matrixStack, -8, showArrow ? y - 9 : y, currentAlpha);
            if (showArrow) {
                Markers.renderArrow(matrixStack, 0, y, currentAlpha);
            }
            if (depthTestEnabled) {
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.disableDepthTest();
            }
            if (blendEnabled) {
                RenderSystem.enableBlend();
            } else {
                RenderSystem.disableBlend();
            }
            matrixStack.func_227865_b_();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static MarkerResource getMarkerResource(Minecraft mc, String professionName, int level) {
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.INSTANCE.overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.INSTANCE.markerType.get()).get()) {
            case ITEMS: {
                ResourceLocation associatedItemKey = MerchantMarkersConfig.INSTANCE.getAssociatedItem(professionName);
                if (associatedItemKey == null) break;
                Item associatedItem = (Item)ForgeRegistries.ITEMS.getValue(associatedItemKey);
                ItemRenderer itemRenderer = mc.func_175599_af();
                IBakedModel bakedModel = itemRenderer.func_184393_a(new ItemStack((IItemProvider)associatedItem), (World)null, (LivingEntity)mc.field_71439_g);
                TextureAtlasSprite sprite = bakedModel.func_177554_e();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.func_195668_m().func_110624_b(), String.format("textures/%s%s", sprite.func_195668_m().func_110623_a(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                ImmutableSet jobBlockStates;
                VillagerProfession profession = (VillagerProfession)Registry.field_218370_L.func_82594_a(new ResourceLocation(professionName.replace("__", ":")));
                if (profession == VillagerProfession.field_221151_a || (jobBlockStates = profession.func_221149_b().getBlockStates()).isEmpty()) break;
                BlockRendererDispatcher blockRenderer = mc.func_175602_ab();
                IBakedModel bakedModel = blockRenderer.func_184389_a((BlockState)jobBlockStates.iterator().next());
                TextureAtlasSprite sprite = bakedModel.func_177554_e();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.func_195668_m().func_110624_b(), String.format("textures/%s%s", sprite.func_195668_m().func_110623_a(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                ResourceLocation iconResource = new ResourceLocation("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.func_195551_G().func_219533_b(iconResource)) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, MatrixStack matrixStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture, matrixStack, x, y, alpha);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            matrixStack.func_227861_a_(0.0, 0.0, -1.0);
            float imageSize = resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, matrixStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize, alpha);
        });
        matrixStack.func_227865_b_();
    }

    private static void renderArrow(MatrixStack matrixStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        Markers.renderIcon(MARKER_ARROW, matrixStack, x - 8, y + 8, 16, 8, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
        matrixStack.func_227865_b_();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level;
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay.value() % 2 * 8, resource.overlay.value() / 2 * 8);
    }

    private static void renderIcon(ResourceLocation icon, MatrixStack matrixStack, int x, int y, float alpha) {
        Markers.renderIcon(icon, matrixStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
    }

    private static void renderIcon(ResourceLocation icon, MatrixStack matrixStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        mc.func_110434_K().func_110577_a(icon);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + w), (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + w), (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u0, v0).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static class MarkerResource {
        public final ResourceLocation texture;
        public final MerchantMarkersConfig.OverlayType overlay;
        public final int level;

        public MarkerResource(ResourceLocation texture, MerchantMarkersConfig.OverlayType overlay, int level) {
            this.texture = texture;
            this.overlay = overlay;
            this.level = level;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.texture, this.overlay, this.level});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MarkerResource)) {
                return false;
            }
            MarkerResource other = (MarkerResource)obj;
            return Objects.equals(this.texture, other.texture) && Objects.equals((Object)this.overlay, (Object)other.overlay) && Objects.equals(this.level, other.level);
        }
    }
}

