/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.util;

import java.io.IOException;
import java.io.InputStream;

public class NullInputStream {
    public static InputStream stream() {
        return new InputStream(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            private int checkFromIndexSize(int fromIndex, int size, int len) {
                if ((len | fromIndex | size) < 0 || size > len - fromIndex) {
                    throw new IndexOutOfBoundsException(String.format("Range [%d, %<d + %d) out of bounds for length %d", fromIndex, size, len));
                }
                return fromIndex;
            }

            @Override
            public int available() throws IOException {
                this.ensureOpen();
                return 0;
            }

            @Override
            public int read() throws IOException {
                this.ensureOpen();
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkFromIndexSize(off, len, b.length);
                if (len == 0) {
                    return 0;
                }
                this.ensureOpen();
                return -1;
            }

            @Override
            public long skip(long n) throws IOException {
                this.ensureOpen();
                return 0L;
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }
}

