/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.network;

import com.anthonyhilyard.iceberg.events.NewItemPickupEvent;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public final class NewItemPickupEventPacket {
    private final UUID playerUUID;
    private final ItemStack item;

    public NewItemPickupEventPacket(UUID playerUUID, ItemStack item) {
        this.playerUUID = playerUUID;
        this.item = item;
    }

    public static void encode(NewItemPickupEventPacket msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.playerUUID);
        packetBuffer.m_130055_(msg.item);
    }

    public static NewItemPickupEventPacket decode(FriendlyByteBuf packetBuffer) {
        return new NewItemPickupEventPacket(packetBuffer.m_130259_(), packetBuffer.m_130267_());
    }

    public static void handle(NewItemPickupEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MinecraftForge.EVENT_BUS.post((Event)new NewItemPickupEvent(msg.playerUUID, msg.item)));
        context.setPacketHandled(true);
    }
}

