/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class Tooltips {
    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, PoseStack poseStack, TooltipInfo info, Rect2i rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        if (info.getLines().isEmpty()) {
            return;
        }
        int rectX = rect.m_110085_() - 8;
        int rectY = rect.m_110086_() + 18;
        int maxTextWidth = rect.m_110090_() - 8;
        RenderTooltipExtEvent.Pre event = new RenderTooltipExtEvent.Pre(stack, info.getLines(), poseStack, rectX, rectY, screenWidth, screenHeight, maxTextWidth, info.getFont(), comparison);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        rectX = event.getX();
        rectY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        info.setFont(event.getFontRenderer());
        RenderSystem.m_69465_();
        int tooltipTextWidth = info.getMaxLineWidth();
        if (constrain) {
            tooltipTextWidth = Math.max(info.getMaxLineWidth(), rect.m_110090_() - 8);
        }
        boolean needsWrap = false;
        int tooltipX = rectX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = rectX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = rectX > screenWidth / 2 ? rectX - 12 - 8 : screenWidth - 16 - rectX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            info.wrap(tooltipTextWidth);
            tooltipTextWidth = info.getTooltipWidth();
            tooltipX = rectX + 12;
        }
        int tooltipY = rectY - 12;
        int tooltipHeight = 8;
        if (info.getLines().size() > 1) {
            tooltipHeight += (info.getLines().size() - 1) * 10;
            if (info.getLines().size() > info.getTitleLines()) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipExtEvent.Color colorEvent = new RenderTooltipExtEvent.Color(stack, info.getLines(), poseStack, tooltipX, tooltipY, info.getFont(), backgroundColor, borderColorStart, borderColorEnd, comparison);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        poseStack.m_85836_();
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, info.getLines(), poseStack, tooltipX, tooltipY, info.getFont(), tooltipTextWidth, tooltipHeight));
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < info.getLines().size(); ++lineNumber) {
            FormattedText line = info.getLines().get(lineNumber);
            if (line != null) {
                info.getFont().m_92733_(Language.m_128107_().m_5536_(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (MultiBufferSource)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == info.getTitleLines()) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.m_109911_();
        poseStack.m_85849_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipExtEvent.PostText(stack, info.getLines(), poseStack, tooltipX, tooltipTop, info.getFont(), tooltipTextWidth, tooltipHeight, comparison));
        RenderSystem.m_69482_();
    }

    public static Rect2i calculateRect(ItemStack stack, PoseStack poseStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        int n;
        Rect2i rect = new Rect2i(0, 0, 0, 0);
        if (textLines == null || textLines.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, poseStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : textLines) {
            int textLineWidth = font.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 14;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 14 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (int i = 0; i < textLines.size(); ++i) {
                FormattedText textLine = textLines.get(i);
                List wrappedLine = font.m_92865_().m_92414_(textLine, tooltipTextWidth, Style.f_131099_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = font.m_92852_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((FormattedText)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 14;
        }
        int tooltipY = mouseY - 14;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        rect = new Rect2i(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8);
        return rect;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private Font font;
        private List<? extends FormattedText> lines = new ArrayList<FormattedText>();

        public TooltipInfo(List<? extends FormattedText> lines, Font font) {
            this.lines = lines;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public Font getFont() {
            return this.font;
        }

        public List<? extends FormattedText> getLines() {
            return this.lines;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            int textWidth = 0;
            for (FormattedText formattedText : this.lines) {
                int textLineWidth = this.font.m_92852_(formattedText);
                if (textLineWidth <= textWidth) continue;
                textWidth = textLineWidth;
            }
            return textWidth;
        }

        public void wrap(int maxWidth) {
            this.tooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedLines = new ArrayList<FormattedText>();
            for (int i = 0; i < this.lines.size(); ++i) {
                FormattedText textLine = this.lines.get(i);
                List wrappedLine = this.font.m_92865_().m_92414_(textLine, maxWidth, Style.f_131099_);
                if (i == 0) {
                    this.titleLines = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = this.font.m_92852_(line);
                    if (lineWidth > this.tooltipWidth) {
                        this.tooltipWidth = lineWidth;
                    }
                    wrappedLines.add((FormattedText)line);
                }
            }
            this.lines = wrappedLines;
        }
    }
}

