/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.world.entity.Entity;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.minimap.XaeroMinimap;

public class XaeroHandler
implements ResourceManagerReloadListener {
    private static XaeroHandler INSTANCE = new XaeroHandler();
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer<?> entityRenderer, Entity entity) {
        String profession = Markers.getProfessionName(entity);
        int professionLevel = Markers.getProfessionLevel(entity);
        if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
            EntityIconDefinitions.buildVariantIdString((StringBuilder)stringBuilder, entityRenderer, (Entity)entity);
        } else {
            stringBuilder.append(profession).append("-").append(professionLevel);
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        XaeroHandler.setupDynamicIcons();
        if (XaeroMinimap.instance.getInterfaces() != null) {
            XaeroMinimap.instance.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        block13: {
            Markers.MarkerResource resource = resourceSupplier.get();
            if (resource == null) {
                return InputStream.nullInputStream();
            }
            if (iconCache.containsKey(resource)) {
                return new ByteArrayInputStream(iconCache.get(resource));
            }
            int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.INSTANCE.minimapIconScale.get());
            int outerSize = 64;
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            BufferedImage newImage = new BufferedImage(64, 64, 2);
            Graphics2D graphics = newImage.createGraphics();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (!manager.m_7165_(resource.texture()) && Minecraft.m_91087_().m_91097_().m_174786_(resource.texture(), null) == null) {
                return InputStream.nullInputStream();
            }
            if (iconOverlayImage == null) {
                iconOverlayImage = ImageIO.read(manager.m_142591_(Markers.ICON_OVERLAY).m_6679_());
            }
            if (numberOverlayImage == null) {
                numberOverlayImage = ImageIO.read(manager.m_142591_(Markers.NUMBER_OVERLAY).m_6679_());
            }
            BufferedImage originalImage = ImageIO.read(manager.m_142591_(resource.texture()).m_6679_());
            int left = (64 - innerSize) / 2;
            int right = (64 + innerSize) / 2;
            int top = (64 + innerSize) / 2;
            int bottom = (64 - innerSize) / 2;
            graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
            Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
                BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
                float scale = (float)innerSize / (float)originalImage.getWidth();
                graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
            });
            graphics.dispose();
            ByteArrayOutputStream byteArrayOutputStream = os;
            try {
                ImageIO.write((RenderedImage)newImage, "png", os);
                iconCache.put(resource, os.toByteArray());
                byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
                if (byteArrayOutputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Loader.LOGGER.error(e.toString());
                    iconCache.put(resource, new byte[0]);
                    return InputStream.nullInputStream();
                }
            }
            byteArrayOutputStream.close();
        }
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager manager = mc.m_91098_();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadableManager = (SimpleReloadableResourceManager)manager;
            Supplier<Collection> delayedResources = () -> reloadableManager.m_6540_("textures/entity/villager/markers", s -> s.endsWith(".png"));
            if (!reloadableManager.f_10871_.contains(INSTANCE)) {
                reloadableManager.f_10871_.add(0, INSTANCE);
            }
            if (((Boolean)MerchantMarkersConfig.INSTANCE.showOnMiniMap.get()).booleanValue()) {
                int minLevel;
                int maxLevel;
                if (!MerchantMarkersConfig.INSTANCE.showLevels()) {
                    maxLevel = 0;
                    minLevel = 0;
                } else {
                    minLevel = 0;
                    maxLevel = 15;
                }
                dynamicPack.registerResource(PackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    for (ResourceLocation marker : (Collection)delayedResources.get()) {
                        for (int i = minLevel; i <= maxLevel; ++i) {
                            String[] components = marker.m_135815_().split("/");
                            String iconName = components[components.length - 1].replace(".png", "");
                            variants.addProperty(iconName + "-" + String.valueOf(i), "sprite:" + marker.m_135815_().replace(".png", "-" + String.valueOf(i) + ".png"));
                        }
                    }
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "com.anthonyhilyard.merchantmarkers.XaeroHandler.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
                for (ResourceLocation marker : delayedResources.get()) {
                    String[] components = marker.m_135815_().split("/");
                    String iconName = components[components.length - 1].replace(".png", "");
                    for (int i = minLevel; i <= maxLevel; ++i) {
                        int level = i;
                        ResourceLocation markerLocation = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + marker.m_135815_().replace(".png", "-" + String.valueOf(i) + ".png"));
                        if (mc.m_91097_().m_174786_(markerLocation, null) != null) {
                            mc.execute(() -> mc.m_91097_().m_118513_(markerLocation));
                        }
                        dynamicPack.registerResource(PackType.CLIENT_RESOURCES, markerLocation, () -> {
                            try {
                                InputStream proxyStream = XaeroHandler.getResizedIcon(() -> Markers.getMarkerResource(mc, iconName, level));
                                if (proxyStream.available() == 0) {
                                    return reloadableManager.m_142591_(Markers.getMarkerResource(mc, iconName, level).texture()).m_6679_();
                                }
                                return proxyStream;
                            }
                            catch (Exception e) {
                                return InputStream.nullInputStream();
                            }
                        });
                    }
                }
            } else {
                dynamicPack.registerResource(PackType.CLIENT_RESOURCES, new ResourceLocation("xaerominimap", "entity/icon/definition/minecraft/villager.json"), () -> {
                    JsonObject variants = new JsonObject();
                    variants.addProperty("default", "model");
                    JsonObject result = new JsonObject();
                    result.addProperty("variantIdBuilderMethod", "xaero.common.minimap.render.radar.EntityIconDefinitions.buildVariantIdString");
                    result.add("variants", (JsonElement)variants);
                    return new ByteArrayInputStream(result.toString().getBytes());
                });
            }
            if (!reloadableManager.m_7536_().anyMatch(pack -> pack.equals(dynamicPack))) {
                reloadableManager.m_10880_((PackResources)dynamicPack);
            }
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            Markers.clearResourceCache();
            XaeroHandler.clearIconCache();
        }
    }
}

