/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FTBChunksHandler {
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");
    private static Entity currentEntity = null;
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    public static final ResourceLocation villagerTexture = new ResourceLocation("ftbchunks", "textures/faces/minecraft/villager.png");
    private static Supplier<InputStream> defaultVillagerResource = null;

    public static void setCurrentEntity(Entity entity) {
        currentEntity = entity;
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.m_91097_().m_174786_(villagerTexture, null) != null) {
                minecraft.m_18709_(() -> minecraft.m_91097_().m_118513_(villagerTexture));
            }
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        FTBChunksHandler.setupDynamicIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        int innerSize;
        Markers.MarkerResource resource = resourceSupplier.get();
        if (resource == null) {
            return InputStream.nullInputStream();
        }
        if (iconCache.containsKey(resource)) {
            return new ByteArrayInputStream(iconCache.get(resource));
        }
        int outerSize = innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.getInstance().minimapIconScale.get());
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        BufferedImage newImage = new BufferedImage(outerSize, outerSize, 2);
        Graphics2D graphics = newImage.createGraphics();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (!manager.m_7165_(resource.texture()) && Minecraft.m_91087_().m_91097_().m_118506_(resource.texture()) == null) {
            return InputStream.nullInputStream();
        }
        if (iconOverlayImage == null) {
            iconOverlayImage = ImageIO.read(manager.m_142591_(Markers.ICON_OVERLAY).m_6679_());
        }
        if (numberOverlayImage == null) {
            numberOverlayImage = ImageIO.read(manager.m_142591_(Markers.NUMBER_OVERLAY).m_6679_());
        }
        BufferedImage originalImage = ImageIO.read(manager.m_142591_(resource.texture()).m_6679_());
        int left = (outerSize - innerSize) / 2;
        int right = (outerSize + innerSize) / 2;
        int top = (outerSize + innerSize) / 2;
        int bottom = (outerSize - innerSize) / 2;
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
        graphics.transform(at);
        graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
            float scale = (float)innerSize / (float)originalImage.getWidth();
            graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
        });
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)newImage, "png", os);
            iconCache.put(resource, os.toByteArray());
            byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                iconCache.put(resource, new byte[0]);
                return InputStream.nullInputStream();
            }
        }
        os.close();
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager manager = mc.m_91098_();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadableManager = (SimpleReloadableResourceManager)manager;
            if (defaultVillagerResource == null) {
                try {
                    for (Resource resource : reloadableManager.m_7396_(villagerTexture)) {
                        if (resource.m_7816_().contentEquals("dynamicicons")) continue;
                        byte[] defaultVillagerBytes = IOUtils.toByteArray((InputStream)resource.m_6679_());
                        defaultVillagerResource = () -> new ByteArrayInputStream(defaultVillagerBytes);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dynamicPack.registerResource(PackType.CLIENT_RESOURCES, villagerTexture, () -> {
                AbstractVillager villager;
                Entity patt6777$temp;
                if (currentEntity == null || (patt6777$temp = currentEntity) instanceof AbstractVillager && (villager = (AbstractVillager)patt6777$temp).m_6162_()) {
                    return InputStream.nullInputStream();
                }
                try {
                    String profession = Markers.getProfessionName(currentEntity);
                    int level = Markers.getProfessionLevel(currentEntity);
                    if (((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(profession)) {
                        return defaultVillagerResource == null ? InputStream.nullInputStream() : defaultVillagerResource.get();
                    }
                    InputStream proxyStream = FTBChunksHandler.getResizedIcon(() -> Markers.getMarkerResource(mc, profession, level));
                    Thread.sleep(1L);
                    if (proxyStream.available() == 0) {
                        return reloadableManager.m_142591_(Markers.getMarkerResource(mc, profession, level).texture()).m_6679_();
                    }
                    return proxyStream;
                }
                catch (Exception e) {
                    return InputStream.nullInputStream();
                }
            });
            if (!reloadableManager.m_7536_().anyMatch(pack -> pack.equals(dynamicPack))) {
                reloadableManager.m_10880_((PackResources)dynamicPack);
            }
        }
    }
}

