/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.mixin;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DrawEntityStep.class}, remap=false)
public class JourneyMapDrawEntityStepMixin {
    @Shadow
    Minecraft minecraft;
    @Shadow
    WeakReference<LivingEntity> entityLivingRef;
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    private static Map<Markers.MarkerResource, TextureImpl> textureCache = new HashMap<Markers.MarkerResource, TextureImpl>();

    @Redirect(method={"drawCreature"}, at=@At(value="INVOKE", target="Ljourneymap/client/render/draw/DrawUtil;drawEntity(Lcom/mojang/blaze3d/vertex/PoseStack;DDDLjourneymap/client/render/texture/TextureImpl;FFD)V", remap=false))
    private void drawEntity(PoseStack poseStack, double x, double y, double heading, TextureImpl textureIn, float alpha, float scale, double rotation) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        TextureImpl texture = textureIn;
        if (entityLiving instanceof AbstractVillager && !((AbstractVillager)entityLiving).m_6162_()) {
            int level;
            String profession = Markers.getProfessionName((Entity)entityLiving);
            Markers.MarkerResource markerResource = Markers.getMarkerResource(this.minecraft, profession, level = Markers.getProfessionLevel((Entity)entityLiving));
            if (!textureCache.containsKey(markerResource)) {
                textureCache.put(markerResource, new TextureImpl(this.getMarkerImage(markerResource), true));
            }
            texture = textureCache.get(markerResource);
        }
        DrawUtil.drawEntity((PoseStack)poseStack, (double)x, (double)y, (double)heading, (TextureImpl)texture, (float)alpha, (float)scale, (double)rotation);
    }

    private BufferedImage getMarkerImage(Markers.MarkerResource resource) {
        int innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.getInstance().minimapIconScale.get());
        int outerSize = 64;
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        BufferedImage newImage = new BufferedImage(64, 64, 2);
        Graphics2D graphics = newImage.createGraphics();
        if (!manager.m_7165_(resource.texture()) && Minecraft.m_91087_().m_91097_().m_174786_(resource.texture(), null) == null) {
            return null;
        }
        try {
            if (iconOverlayImage == null) {
                iconOverlayImage = ImageIO.read(manager.m_142591_(Markers.ICON_OVERLAY).m_6679_());
            }
            if (numberOverlayImage == null) {
                numberOverlayImage = ImageIO.read(manager.m_142591_(Markers.NUMBER_OVERLAY).m_6679_());
            }
            BufferedImage originalImage = ImageIO.read(manager.m_142591_(resource.texture()).m_6679_());
            int left = (64 - innerSize) / 2;
            int right = (64 + innerSize) / 2;
            int top = (64 + innerSize) / 2;
            int bottom = (64 - innerSize) / 2;
            AffineTransform at = new AffineTransform();
            at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
            at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
            graphics.transform(at);
            graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
            Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
                BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
                float scale = (float)innerSize / (float)originalImage.getWidth();
                graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
            });
            graphics.dispose();
        }
        catch (Exception e) {
            return null;
        }
        return newImage;
    }
}

