/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class Markers {
    public static final ResourceLocation MARKER_ARROW = new ResourceLocation("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final ResourceLocation ICON_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final ResourceLocation NUMBER_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("merchantmarkers", "textures/entity/villager/default.png");
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static String getProfessionName(Entity entity) {
        String iconName = "default";
        iconName = entity instanceof Villager ? ((Villager)entity).m_7141_().m_35571_().toString().replace(":", "__") : (entity instanceof WanderingTrader ? "wandering_trader" : entity.getClass().getName().toLowerCase());
        return iconName;
    }

    public static int getProfessionLevel(Entity entity) {
        int level = 0;
        if (MerchantMarkersConfig.getInstance().showLevels() && entity instanceof Villager) {
            level = ((Villager)entity).m_7141_().m_35576_();
        }
        return level;
    }

    public static void renderMarker(EntityRenderer<?> renderer, Entity entity, Component component, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity instanceof AbstractVillager) {
            double maxDistance;
            Minecraft mc = Minecraft.m_91087_();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            if (((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(profession)) {
                return;
            }
            double squareDistance = renderer.f_114476_.m_114471_(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.getInstance().maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.getInstance().fadePercent.get();
            double currentAlpha = 1.0;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = Mth.m_14008_((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
                currentAlpha *= ((Double)MerchantMarkersConfig.getInstance().opacity.get()).doubleValue();
            }
            float entityHeight = entity.m_20206_() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.getInstance().verticalOffset.get()).intValue();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)entityHeight, 0.0);
            poseStack.m_85845_(renderer.f_114476_.m_114470_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69465_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f * (float)currentAlpha));
            boolean showArrow = (Boolean)MerchantMarkersConfig.getInstance().showArrow.get();
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y);
            }
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y);
            if (((Boolean)MerchantMarkersConfig.getInstance().showThroughWalls.get()).booleanValue()) {
                RenderSystem.m_69482_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)currentAlpha));
                Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y);
                if (showArrow) {
                    Markers.renderArrow(poseStack, 0, y);
                }
            }
            poseStack.m_85849_();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static MarkerResource getMarkerResource(Minecraft mc, String professionName, int level) {
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.getInstance().overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.getInstance().markerType.get()).get()) {
            case ITEMS: {
                ResourceLocation associatedItemKey = MerchantMarkersConfig.getInstance().getAssociatedItem(professionName);
                if (associatedItemKey == null) break;
                Item associatedItem = (Item)ForgeRegistries.ITEMS.getValue(associatedItemKey);
                ItemRenderer itemRenderer = mc.m_91291_();
                BakedModel bakedModel = itemRenderer.m_174264_(new ItemStack((ItemLike)associatedItem), (Level)null, (LivingEntity)mc.f_91074_, 0);
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_118413_().m_135827_(), String.format("textures/%s%s", sprite.m_118413_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                ImmutableSet jobBlockStates;
                VillagerProfession profession = (VillagerProfession)Registry.f_122869_.m_7745_(new ResourceLocation(professionName.replace("__", ":")));
                if (profession == VillagerProfession.f_35585_ || (jobBlockStates = profession.m_35622_().getBlockStates()).isEmpty()) break;
                BlockRenderDispatcher blockRenderer = mc.m_91289_();
                BakedModel bakedModel = blockRenderer.m_110910_((BlockState)jobBlockStates.iterator().next());
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_118413_().m_135827_(), String.format("textures/%s%s", sprite.m_118413_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                ResourceLocation iconResource = new ResourceLocation("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.m_91098_().m_7165_(iconResource)) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, PoseStack poseStack, int x, int y) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture(), poseStack, x, y);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            poseStack.m_85837_(0.0, 0.0, -1.0);
            float imageSize = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, poseStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize);
        });
        poseStack.m_85849_();
    }

    private static void renderArrow(PoseStack poseStack, int x, int y) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MARKER_ARROW);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x - 8), (int)(y + 8), (float)0.0f, (float)0.0f, (int)16, (int)8, (int)16, (int)8);
        poseStack.m_85849_();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level();
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay().value() % 2 * 8, resource.overlay().value() / 2 * 8);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y) {
        Markers.renderIcon(icon, poseStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Minecraft.m_91087_().m_91097_().m_118506_(icon).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public record MarkerResource(ResourceLocation texture, MerchantMarkersConfig.OverlayType overlay, int level) {
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

