/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_776;
import net.minecraft.class_897;
import net.minecraft.class_918;

public class Markers {
    public static final class_2960 MARKER_ARROW = new class_2960("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final class_2960 ICON_OVERLAY = new class_2960("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final class_2960 NUMBER_OVERLAY = new class_2960("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final class_2960 DEFAULT_ICON = new class_2960("merchantmarkers", "textures/entity/villager/default.png");
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static String getProfessionName(class_1297 entity) {
        String iconName = "default";
        iconName = entity instanceof class_1646 ? ((class_1646)entity).method_7231().method_16924().toString().replace(":", "__") : (entity instanceof class_3989 ? "wandering_trader" : entity.getClass().getName().toLowerCase());
        return iconName;
    }

    public static int getProfessionLevel(class_1297 entity) {
        int level = 0;
        if (MerchantMarkersConfig.INSTANCE.showLevels() && entity instanceof class_1646) {
            level = ((class_1646)entity).method_7231().method_16925();
        }
        return level;
    }

    public static void renderMarker(class_897<?> renderer, class_1297 entity, class_2561 component, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (entity instanceof class_3988) {
            double maxDistance;
            class_310 mc = class_310.method_1551();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            if (((List)MerchantMarkersConfig.INSTANCE.professionBlacklist.get()).contains(profession)) {
                return;
            }
            double squareDistance = renderer.field_4676.method_23168(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.INSTANCE.maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.INSTANCE.fadePercent.get();
            double currentAlpha = 1.0;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = class_3532.method_15350((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
            }
            float entityHeight = entity.method_17682() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.INSTANCE.verticalOffset.get()).intValue();
            poseStack.method_22903();
            poseStack.method_22904(0.0, (double)entityHeight, 0.0);
            poseStack.method_22907(renderer.field_4676.method_24197());
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f * (float)currentAlpha));
            boolean showArrow = (Boolean)MerchantMarkersConfig.INSTANCE.showArrow.get();
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y);
            }
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)currentAlpha));
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y);
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y);
            }
            poseStack.method_22909();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static MarkerResource getMarkerResource(class_310 mc, String professionName, int level) {
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.INSTANCE.overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.INSTANCE.markerType.get()).get()) {
            case ITEMS: {
                class_2960 associatedItemKey = MerchantMarkersConfig.INSTANCE.getAssociatedItem(professionName);
                if (associatedItemKey == null || !class_2378.field_11142.method_10250(associatedItemKey)) break;
                class_1792 associatedItem = (class_1792)class_2378.field_11142.method_17966(associatedItemKey).get();
                class_918 itemRenderer = mc.method_1480();
                class_1087 bakedModel = itemRenderer.method_4019(new class_1799((class_1935)associatedItem), (class_1937)null, (class_1309)mc.field_1724, 0);
                class_1058 sprite = bakedModel.method_4711();
                class_2960 spriteLocation = new class_2960(sprite.method_4598().method_12836(), String.format("textures/%s%s", sprite.method_4598().method_12832(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                Set jobBlockStates;
                class_3852 profession = (class_3852)class_2378.field_17167.method_10223(new class_2960(professionName.replace("__", ":")));
                if (profession == class_3852.field_17051 || (jobBlockStates = profession.method_19198().field_18850).isEmpty()) break;
                class_776 blockRenderer = mc.method_1541();
                class_1087 bakedModel = blockRenderer.method_3349((class_2680)jobBlockStates.iterator().next());
                class_1058 sprite = bakedModel.method_4711();
                class_2960 spriteLocation = new class_2960(sprite.method_4598().method_12836(), String.format("textures/%s%s", sprite.method_4598().method_12832(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                class_2960 iconResource = new class_2960("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.method_1478().method_18234(iconResource)) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, class_4587 poseStack, int x, int y) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture(), poseStack, x, y);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            poseStack.method_22904(0.0, 0.0, -1.0);
            float imageSize = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, poseStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize);
        });
        poseStack.method_22909();
    }

    private static void renderArrow(class_4587 poseStack, int x, int y) {
        float scale = (float)((Double)MerchantMarkersConfig.INSTANCE.iconScale.get()).doubleValue();
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)MARKER_ARROW);
        class_332.method_25290((class_4587)poseStack, (int)(x - 8), (int)(y + 8), (float)0.0f, (float)0.0f, (int)16, (int)8, (int)16, (int)8);
        poseStack.method_22909();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level();
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay().value() % 2 * 8, resource.overlay().value() / 2 * 8);
    }

    private static void renderIcon(class_2960 icon, class_4587 poseStack, int x, int y) {
        Markers.renderIcon(icon, poseStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void renderIcon(class_2960 icon, class_4587 poseStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1) {
        class_1159 matrix = poseStack.method_23760().method_23761();
        class_310.method_1551().method_1531().method_4619(icon).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)icon);
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(u0, v1).method_1344();
        bufferbuilder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(u1, v1).method_1344();
        bufferbuilder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(u1, v0).method_1344();
        bufferbuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(u0, v0).method_1344();
        bufferbuilder.method_1326();
        class_286.method_1309((class_287)bufferbuilder);
    }

    public record MarkerResource(class_2960 texture, MerchantMarkersConfig.OverlayType overlay, int level) {
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

