/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_5251;

public class Selectors {
    private static Map<String, class_1814> rarities = new HashMap<String, class_1814>(){
        {
            this.put("common", class_1814.field_8906);
            this.put("uncommon", class_1814.field_8907);
            this.put("rare", class_1814.field_8903);
            this.put("epic", class_1814.field_8904);
        }
    };
    private static Map<String, BiPredicate<class_2520, String>> nbtComparators = new HashMap<String, BiPredicate<class_2520, String>>(){
        {
            this.put("=", (tag, value) -> tag.method_10714().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.method_10714().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof class_2514) {
                        return ((class_2514)tag).method_10697() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static boolean validateSelector(String value) {
        if (value.startsWith("$")) {
            return class_2960.method_20207((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return class_5251.method_27719((String)value) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || class_2960.method_20207((String)value);
    }

    public static boolean itemMatches(class_1799 item, String selector) {
        String itemResourceLocation = class_2378.field_11142.method_10221((Object)item.method_7909()).toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("#")) {
            class_5251 entryColor = class_5251.method_27719((String)selector);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, class_5251.method_27717((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.method_7932() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            if (class_3489.method_15106().method_30213(new class_2960(selector.substring(1))).method_15138().contains(item.method_7909())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.method_7954().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            class_310 mc = class_310.method_1551();
            List lines = item.method_7950((class_1657)mc.field_1724, (class_1836)class_1836.class_1837.field_8935);
            Object tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = (String)tooltipText + ((class_2561)lines.get(n)).getString() + "\n";
            }
            if (((String)tooltipText).contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            class_2520 matchedTag;
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<class_2520, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            if ((matchedTag = Selectors.getSubtag(item.method_7969(), tagName)) != null) {
                if (tagValue == null) {
                    return true;
                }
                if (valueChecker != null) {
                    return valueChecker.test(matchedTag, tagValue);
                }
            }
        }
        return false;
    }

    private static class_2520 getSubtag(class_2487 tag, String key) {
        if (tag == null) {
            return null;
        }
        if (tag.method_10545(key)) {
            return tag.method_10580(key);
        }
        for (String innerKey : tag.method_10541()) {
            class_2520 innerTag;
            if (tag.method_10540(innerKey) != 10 || (innerTag = Selectors.getSubtag(tag.method_10562(innerKey), key)) == null) continue;
            return innerTag;
        }
        return null;
    }
}

