/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.StringRecomposer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_918;

public class Tooltips {
    private static boolean initialized = false;
    private static class_918 itemRenderer = null;

    private static void init(class_310 minecraft) {
        itemRenderer = minecraft.method_1480();
        initialized = true;
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, poseStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(class_1799 stack, class_4587 poseStack, TooltipInfo info, class_768 rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        class_5684 clientTooltipComponent3;
        int i;
        if (!initialized) {
            Tooltips.init(class_310.method_1551());
        }
        if (info.lines.isEmpty()) {
            return;
        }
        int rectX = rect.method_3321() - 8;
        int rectY = rect.method_3322() + 18;
        int maxTextWidth = rect.method_3319() - 8;
        class_1269 result = ((RenderTooltipEvents.Pre)RenderTooltipEvents.PRE.invoker()).onPre(stack, info.getLines(), poseStack, rectX, rectY, screenWidth, screenHeight, maxTextWidth, info.getFont(), comparison);
        if (result != class_1269.field_5811) {
            return;
        }
        boolean needsWrap = false;
        int tooltipX = rectX + 12;
        int tooltipTextWidth = info.getMaxLineWidth();
        if (constrain) {
            tooltipTextWidth = Math.max(info.getMaxLineWidth(), rect.method_3319() - 8);
        }
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = rectX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = rectX > screenWidth / 2 ? rectX - 20 : screenWidth - 16 - rectX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            info.wrap(tooltipTextWidth);
            tooltipTextWidth = info.getTooltipWidth();
            tooltipX = rectX + 12;
        }
        int tooltipY = rectY - 12;
        int tooltipHeight = 8;
        if (info.getLines().size() > 1) {
            tooltipHeight += (info.getLines().size() - 1) * 10;
            if (info.getLines().size() > info.getTitleLines()) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        poseStack.method_22903();
        int bgColor = -267386864;
        int borderStart = 0x505000FF;
        int borderEnd = 1344798847;
        RenderTooltipEvents.ColorResult colors = ((RenderTooltipEvents.Color)RenderTooltipEvents.COLOR.invoker()).onColor(stack, info.lines, poseStack, tooltipX, tooltipY, info.getFont(), bgColor, borderStart, borderEnd, comparison);
        bgColor = colors.background();
        borderStart = colors.borderStart();
        borderEnd = colors.borderEnd();
        float f = Tooltips.itemRenderer.field_4730;
        Tooltips.itemRenderer.field_4730 = 400.0f;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 mat = poseStack.method_23760().method_23761();
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, 400, bgColor, bgColor);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, 400, bgColor, bgColor);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 400, bgColor, bgColor);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, 400, bgColor, bgColor);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, 400, bgColor, bgColor);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 400, borderStart, borderEnd);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 400, borderStart, borderEnd);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 400, borderStart, borderStart);
        GuiHelper.drawGradientRect(mat, bufferBuilder, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 400, borderEnd, borderEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22904(0.0, 0.0, 400.0);
        int v = tooltipY;
        for (i = 0; i < info.getLines().size(); ++i) {
            clientTooltipComponent3 = info.getLines().get(i);
            clientTooltipComponent3.method_32665(info.getFont(), tooltipX, v, mat, bufferSource);
            v += clientTooltipComponent3.method_32661() + (i == 0 ? 2 : 0);
        }
        bufferSource.method_22993();
        poseStack.method_22909();
        v = tooltipY;
        for (i = 0; i < info.getLines().size(); ++i) {
            clientTooltipComponent3 = info.getLines().get(i);
            clientTooltipComponent3.method_32666(info.getFont(), tooltipX, v, poseStack, itemRenderer, 400);
            v += clientTooltipComponent3.method_32661() + (i == 0 ? 2 : 0);
        }
        Tooltips.itemRenderer.field_4730 = f;
        ((RenderTooltipEvents.Post)RenderTooltipEvents.POST.invoker()).onPost(stack, info.getLines(), poseStack, tooltipX, tooltipY, info.getFont(), tooltipTextWidth, tooltipHeight, comparison);
    }

    public static class_768 calculateRect(class_1799 stack, class_4587 poseStack, List<class_5684> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font) {
        class_768 rect = new class_768(0, 0, 0, 0);
        if (textLines == null || textLines.isEmpty() || stack == null) {
            return rect;
        }
        int tooltipTextWidth = 0;
        for (class_5684 textLine : textLines) {
            int textLineWidth = textLine.method_32664(font);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 14;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 14 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            TooltipInfo info = new TooltipInfo(textLines, font);
            info.wrap(tooltipTextWidth);
            tooltipTextWidth = info.tooltipWidth;
            textLines = info.lines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 14;
        }
        int tooltipY = mouseY - 14;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        rect = new class_768(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8);
        return rect;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private class_327 font;
        private List<class_5684> lines = new ArrayList<class_5684>();

        public TooltipInfo(List<class_5684> lines, class_327 font) {
            this.lines = lines;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public class_327 getFont() {
            return this.font;
        }

        public List<class_5684> getLines() {
            return this.lines;
        }

        public void setFont(class_327 font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            int textWidth = 0;
            for (class_5684 component : this.lines) {
                int textLineWidth = component.method_32664(this.font);
                if (textLineWidth <= textWidth) continue;
                textWidth = textLineWidth;
            }
            return textWidth;
        }

        private List<class_5683> splitComponent(class_5683 component, int maxWidth, class_327 font) {
            class_5348 text = class_5348.method_29432(StringRecomposer.recompose(Arrays.asList(component)));
            List wrappedLines = font.method_27527().method_27495(text, maxWidth, class_2583.field_24360);
            ArrayList<class_5683> result = new ArrayList<class_5683>();
            for (class_5348 wrappedLine : wrappedLines) {
                result.add(new class_5683(class_2477.method_10517().method_30934(wrappedLine)));
            }
            return result;
        }

        public void wrap(int maxWidth) {
            this.tooltipWidth = 0;
            ArrayList<class_5684> wrappedLines = new ArrayList<class_5684>();
            for (int i = 0; i < this.lines.size(); ++i) {
                class_5684 textLine = this.lines.get(i);
                if (!(textLine instanceof class_5683)) continue;
                List<class_5683> wrappedLine = this.splitComponent((class_5683)textLine, maxWidth, this.font);
                if (i == 0) {
                    this.titleLines = wrappedLine.size();
                }
                for (class_5684 class_56842 : wrappedLine) {
                    int lineWidth = class_56842.method_32664(this.font);
                    if (lineWidth > this.tooltipWidth) {
                        this.tooltipWidth = lineWidth;
                    }
                    wrappedLines.add(class_56842);
                }
            }
            this.lines = wrappedLines;
        }
    }
}

