/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.render;

import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.compat.OptifineHandler;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class Markers {
    public static final ResourceLocation MARKER_ARROW = new ResourceLocation("merchantmarkers", "textures/entity/villager/arrow.png");
    public static final ResourceLocation ICON_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/overlay.png");
    public static final ResourceLocation NUMBER_OVERLAY = new ResourceLocation("merchantmarkers", "textures/entity/villager/numbers.png");
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("merchantmarkers", "textures/entity/villager/default.png");
    public static final ResourceLocation EMPTY_MARKER = new ResourceLocation("merchantmarkers", "textures/entity/villager/empty.png");
    private static Supplier<InputStream> emptyMarkerResource = null;
    private static Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();

    public static InputStream getEmptyInputStream() {
        if (emptyMarkerResource == null) {
            emptyMarkerResource = () -> {
                Minecraft mc = Minecraft.m_91087_();
                ResourceManager manager = mc.m_91098_();
                try {
                    return manager.m_142591_(EMPTY_MARKER).m_6679_();
                }
                catch (Exception e) {
                    return InputStream.nullInputStream();
                }
            };
        }
        return (InputStream)emptyMarkerResource.get();
    }

    public static String getProfessionName(Entity entity) {
        String iconName = "default";
        iconName = entity instanceof Villager ? ((Villager)entity).m_7141_().m_35571_().toString().replace(":", "__") : (entity instanceof WanderingTrader ? "wandering_trader" : entity.getClass().getName().toLowerCase());
        return iconName;
    }

    public static int getProfessionLevel(Entity entity) {
        int level = 0;
        if (MerchantMarkersConfig.getInstance().showLevels() && entity instanceof Villager) {
            level = ((Villager)entity).m_7141_().m_35576_();
        }
        return level;
    }

    public static void renderMarker(EntityRenderer<?> renderer, Entity entity, Component component, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity instanceof AbstractVillager) {
            double maxDistance;
            Minecraft mc = Minecraft.m_91087_();
            String profession = Markers.getProfessionName(entity);
            int level = Markers.getProfessionLevel(entity);
            if (((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(profession)) {
                return;
            }
            double squareDistance = renderer.f_114476_.m_114471_(entity);
            if (squareDistance > (maxDistance = ((Double)MerchantMarkersConfig.getInstance().maxDistance.get()).doubleValue()) * maxDistance) {
                return;
            }
            double fadePercent = (Double)MerchantMarkersConfig.getInstance().fadePercent.get();
            float currentAlpha = 1.0f;
            if (fadePercent < 100.0) {
                double startFade = (1.0 - fadePercent / 100.0) * maxDistance;
                currentAlpha = (float)Mth.m_14008_((double)(1.0 - (Math.sqrt(squareDistance) - startFade) / (maxDistance - startFade)), (double)0.0, (double)1.0);
                currentAlpha = (float)((double)currentAlpha * (Double)MerchantMarkersConfig.getInstance().opacity.get());
            }
            float entityHeight = entity.m_20206_() + 0.5f;
            int y = "deadmau5".equals(component.getString()) ? -28 : -18;
            y -= ((Integer)MerchantMarkersConfig.getInstance().verticalOffset.get()).intValue();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)entityHeight, 0.0);
            poseStack.m_85845_(renderer.f_114476_.m_114470_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            boolean depthTestEnabled = GL11.glIsEnabled((int)2929);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            boolean showArrow = (Boolean)MerchantMarkersConfig.getInstance().showArrow.get();
            if (((Boolean)MerchantMarkersConfig.getInstance().showThroughWalls.get()).booleanValue()) {
                RenderSystem.m_69465_();
                Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, 0.3f * currentAlpha);
                if (showArrow) {
                    Markers.renderArrow(poseStack, 0, y, 0.3f * currentAlpha);
                }
            }
            RenderSystem.m_69482_();
            Markers.renderMarker(Markers.getMarkerResource(mc, profession, level), poseStack, -8, showArrow ? y - 9 : y, currentAlpha);
            if (showArrow) {
                Markers.renderArrow(poseStack, 0, y, currentAlpha);
            }
            if (depthTestEnabled) {
                RenderSystem.m_69482_();
            } else {
                RenderSystem.m_69465_();
            }
            poseStack.m_85849_();
        }
    }

    public static void clearResourceCache() {
        resourceCache.clear();
    }

    public static MarkerResource getMarkerResource(Minecraft mc, String professionName, int level) {
        String resourceKey = String.format("%s-%d", professionName, level);
        if (resourceCache.containsKey(resourceKey)) {
            return resourceCache.get(resourceKey);
        }
        MarkerResource result = null;
        MerchantMarkersConfig.OverlayType overlayType = MerchantMarkersConfig.OverlayType.fromValue((Integer)MerchantMarkersConfig.getInstance().overlayIndex.get()).orElse(MerchantMarkersConfig.OverlayType.NONE);
        switch (MerchantMarkersConfig.MarkerType.fromText((String)MerchantMarkersConfig.getInstance().markerType.get()).get()) {
            case ITEMS: {
                ResourceLocation associatedItemKey = MerchantMarkersConfig.getInstance().getAssociatedItem(professionName);
                if (associatedItemKey == null) break;
                Item associatedItem = (Item)ForgeRegistries.ITEMS.getValue(associatedItemKey);
                ItemRenderer itemRenderer = mc.m_91291_();
                BakedModel bakedModel = itemRenderer.m_174264_(new ItemStack((ItemLike)associatedItem), (Level)null, (LivingEntity)mc.f_91074_, 0);
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_118413_().m_135827_(), String.format("textures/%s%s", sprite.m_118413_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            case JOBS: {
                ImmutableSet jobBlockStates;
                VillagerProfession profession = (VillagerProfession)Registry.f_122869_.m_7745_(new ResourceLocation(professionName.replace("__", ":")));
                if (profession == VillagerProfession.f_35585_ || (jobBlockStates = profession.m_35622_().getBlockStates()).isEmpty()) break;
                BlockRenderDispatcher blockRenderer = mc.m_91289_();
                BakedModel bakedModel = blockRenderer.m_110910_((BlockState)jobBlockStates.iterator().next());
                TextureAtlasSprite sprite = bakedModel.m_6160_();
                ResourceLocation spriteLocation = new ResourceLocation(sprite.m_118413_().m_135827_(), String.format("textures/%s%s", sprite.m_118413_().m_135815_(), ".png"));
                result = new MarkerResource(spriteLocation, overlayType, level);
                break;
            }
            default: {
                ResourceLocation iconResource = new ResourceLocation("merchantmarkers", String.format("textures/entity/villager/markers/%s.png", professionName));
                if (!mc.m_91098_().m_7165_(iconResource)) break;
                result = new MarkerResource(iconResource, overlayType, level);
            }
            case GENERIC: 
        }
        if (result == null) {
            result = new MarkerResource(DEFAULT_ICON, overlayType, level);
        }
        resourceCache.put(resourceKey, result);
        return result;
    }

    private static void renderMarker(MarkerResource resource, PoseStack poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        Markers.renderIcon(resource.texture(), poseStack, x, y, alpha);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            poseStack.m_85837_(0.0, 0.0, -1.0);
            float imageSize = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? 32.0f : 16.0f;
            Markers.renderIcon(resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? NUMBER_OVERLAY : ICON_OVERLAY, poseStack, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize, alpha);
        });
        poseStack.m_85849_();
    }

    private static void renderArrow(PoseStack poseStack, int x, int y, float alpha) {
        float scale = (float)((Double)MerchantMarkersConfig.getInstance().iconScale.get()).doubleValue();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        Markers.renderIcon(MARKER_ARROW, poseStack, x - 8, y + 8, 16, 8, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }

    public static void renderOverlay(MarkerResource resource, OverlayRendererMethod method) {
        if (resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL) {
            Markers.renderOverlayLevel(resource, method);
        } else if (resource.overlay != MerchantMarkersConfig.OverlayType.NONE) {
            Markers.renderOverlayIcon(resource, method);
        }
    }

    private static void renderOverlayLevel(MarkerResource resource, OverlayRendererMethod method) {
        int processedDigits = resource.level();
        int xOffset = 8;
        while (processedDigits > 0) {
            int currentDigit = processedDigits % 10;
            method.accept(xOffset, 8, 8, 8, currentDigit % 4 * 8, currentDigit / 4 * 8);
            processedDigits /= 10;
            xOffset -= 5;
        }
    }

    private static void renderOverlayIcon(MarkerResource resource, OverlayRendererMethod method) {
        method.accept(8, 8, 8, 8, resource.overlay().value() % 2 * 8, resource.overlay().value() / 2 * 8);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y, float alpha) {
        Markers.renderIcon(icon, poseStack, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f, alpha);
    }

    private static void renderIcon(ResourceLocation icon, PoseStack poseStack, int x, int y, int w, int h, float u0, float u1, float v0, float v1, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Minecraft.m_91087_().m_91097_().m_118506_(icon).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_85982_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(u0, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(u1, v0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(u0, v0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_85721_();
        if (OptifineHandler.optifineInstalled()) {
            Pair pair = bufferbuilder.m_85728_();
            BufferBuilder.DrawState drawState = (BufferBuilder.DrawState)pair.getFirst();
            Markers._end((ByteBuffer)pair.getSecond(), drawState.m_166810_(), drawState.m_85745_(), drawState.m_85746_(), drawState.m_166811_(), drawState.m_166809_(), drawState.m_166815_());
        } else {
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        }
    }

    private static void _end(ByteBuffer byteBuffer, VertexFormat.Mode vertexMode, VertexFormat vertexFormat, int vertexCount, VertexFormat.IndexType indexType, int indexCount, boolean sequentialIndex) {
        RenderSystem.m_187554_();
        byteBuffer.clear();
        if (vertexCount > 0) {
            int j;
            int i = vertexCount * vertexFormat.m_86020_();
            Markers.updateVertexSetup(vertexFormat);
            byteBuffer.position(0);
            byteBuffer.limit(i);
            GlStateManager.m_84256_((int)34962, (ByteBuffer)byteBuffer, (int)35048);
            if (sequentialIndex) {
                RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.m_157193_((VertexFormat.Mode)vertexMode, (int)indexCount);
                int k = rendersystem$autostorageindexbuffer.m_157475_();
                GlStateManager.m_84480_((int)34963, (int)k);
                j = rendersystem$autostorageindexbuffer.m_157483_().f_166923_;
            } else {
                int i1 = vertexFormat.m_166915_();
                GlStateManager.m_84480_((int)34963, (int)i1);
                byteBuffer.position(i);
                byteBuffer.limit(i + indexCount * indexType.f_166924_);
                GlStateManager.m_84256_((int)34963, (ByteBuffer)byteBuffer, (int)35048);
                j = indexType.f_166923_;
            }
            ShaderInstance shaderinstance = RenderSystem.m_157196_();
            for (int j1 = 0; j1 < 8; ++j1) {
                int l = RenderSystem.m_157203_((int)j1);
                shaderinstance.m_173350_("Sampler" + j1, (Object)l);
            }
            if (shaderinstance.f_173308_ != null) {
                shaderinstance.f_173308_.m_5679_(RenderSystem.m_157190_());
            }
            if (shaderinstance.f_173309_ != null) {
                shaderinstance.f_173309_.m_5679_(RenderSystem.m_157192_());
            }
            if (shaderinstance.f_200956_ != null) {
                shaderinstance.f_200956_.m_200759_(RenderSystem.m_200906_());
            }
            if (shaderinstance.f_173312_ != null) {
                shaderinstance.f_173312_.m_5941_(RenderSystem.m_157197_());
            }
            if (shaderinstance.f_173315_ != null) {
                shaderinstance.f_173315_.m_5985_(RenderSystem.m_157200_());
            }
            if (shaderinstance.f_173316_ != null) {
                shaderinstance.f_173316_.m_5985_(RenderSystem.m_157199_());
            }
            if (shaderinstance.f_173317_ != null) {
                shaderinstance.f_173317_.m_5941_(RenderSystem.m_157198_());
            }
            if (shaderinstance.f_202432_ != null) {
                shaderinstance.f_202432_.m_142617_(RenderSystem.m_202041_().m_202324_());
            }
            if (shaderinstance.f_173310_ != null) {
                shaderinstance.f_173310_.m_5679_(RenderSystem.m_157207_());
            }
            if (shaderinstance.f_173319_ != null) {
                shaderinstance.f_173319_.m_5985_(RenderSystem.m_157201_());
            }
            if (shaderinstance.f_173311_ != null) {
                Window window = Minecraft.m_91087_().m_91268_();
                shaderinstance.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
            }
            RenderSystem.m_157461_((ShaderInstance)shaderinstance);
            shaderinstance.m_173363_();
            GlStateManager.m_157053_((int)vertexMode.f_166946_, (int)indexCount, (int)j, (long)0L);
            shaderinstance.m_173362_();
            byteBuffer.position(0);
        }
    }

    private static void updateVertexSetup(VertexFormat vertexFormat) {
        BufferUploader.m_166835_();
        GlStateManager.m_157068_((int)vertexFormat.m_166913_());
        GlStateManager.m_84480_((int)34962, (int)vertexFormat.m_166914_());
        vertexFormat.m_166912_();
    }

    public record MarkerResource(ResourceLocation texture, MerchantMarkersConfig.OverlayType overlay, int level) {
    }

    @FunctionalInterface
    public static interface OverlayRendererMethod {
        public void accept(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

