/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.capability.CapabilityRegisterHelper;
import com.mz.mobaspects.config.ServerConfig;
import com.mz.mobaspects.effects.CustomEffectRegistry;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.entity.ParasiteEntity;
import com.mz.mobaspects.entity.renderer.AspectShieldRenderer;
import com.mz.mobaspects.entity.renderer.GhastBuddyRenderer;
import com.mz.mobaspects.entity.renderer.OverloadCrystalRenderer;
import com.mz.mobaspects.entity.renderer.ParasiteRenderer;
import com.mz.mobaspects.entity.renderer.TotemOfUndyingRenderer;
import com.mz.mobaspects.events.AspectEventHandler;
import com.mz.mobaspects.events.gui.UiEventHandler;
import com.mz.mobaspects.network.NetworkHandler;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mobaspects")
public class MobAspects {
    public static final String MOD_ID = "mobaspects";
    public static final Logger LOGGER = LogManager.getLogger();

    public MobAspects() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CustomEntityRegister.ENTITY_TYPES.register(modEventBus);
        CustomEffectRegistry.MOB_EFFECTS_REGISTRY.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ServerConfig.SPEC, "mobaspects.server.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        AspectManager.INSTANCE.InitializeAspectList();
        NetworkHandler.init();
        CapabilityRegisterHelper.register();
        MinecraftForge.EVENT_BUS.register((Object)new AspectEventHandler());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UiEventHandler());
        EntityRenderers.m_174036_((EntityType)((EntityType)CustomEntityRegister.GHAST_BUDDY.get()), GhastBuddyRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CustomEntityRegister.UNDYING_TOTEM.get()), TotemOfUndyingRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CustomEntityRegister.OVERLOAD_CRYSTAL.get()), OverloadCrystalRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CustomEntityRegister.ASPECT_PARASITE.get()), ParasiteRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CustomEntityRegister.ASPECT_SHIELD.get()), AspectShieldRenderer::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }

        @SubscribeEvent
        public static void addEntityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)CustomEntityRegister.ASPECT_PARASITE.get(), ParasiteEntity.setCustomAttributes());
        }
    }
}

