/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractAspect {
    private ForgeConfigSpec.BooleanValue enabled;
    protected final IAspectHandler handler;

    public AbstractAspect(IAspectHandler handler) {
        this.handler = handler;
    }

    public IAspectHandler getHandler() {
        return this.handler;
    }

    public abstract void applyConfigToHandler();

    public abstract AspectEnum getCode();

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    protected abstract void buildAspectSpecific(ForgeConfigSpec.Builder var1);

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        builder.push(this.getCode().toString());
        builder.comment("Is this aspect enabled");
        this.enabled = builder.define("enabled", true);
        this.buildAspectSpecific(builder);
        builder.pop();
    }
}

