/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.HeavyAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class HeavyAspect
extends AbstractAspect {
    private ForgeConfigSpec.DoubleValue speedMultiplier;
    private ForgeConfigSpec.DoubleValue healthMultiplier;
    private ForgeConfigSpec.DoubleValue knockbackAddition;
    private ForgeConfigSpec.DoubleValue knockbackResistanceAddition;

    public HeavyAspect() {
        super(new HeavyAspectHandler());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.HEAVY;
    }

    @Override
    public void applyConfigToHandler() {
        ((HeavyAspectHandler)this.handler).setConfig(((Double)this.speedMultiplier.get()).floatValue() - 1.0f, ((Double)this.healthMultiplier.get()).floatValue() - 1.0f, ((Double)this.knockbackAddition.get()).floatValue(), ((Double)this.knockbackResistanceAddition.get()).floatValue());
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Speed multiplier");
        this.speedMultiplier = builder.defineInRange("speedMultiplier", 0.5, 0.0, 1.0);
        builder.comment("Health multiplier");
        this.healthMultiplier = builder.defineInRange("healthMultiplier", 2.0, 1.0, 100.0);
        builder.comment("Knockback addition");
        this.knockbackAddition = builder.defineInRange("knockbackAddition", 0.3, 0.0, 5.0);
        builder.comment("Knockback resistance addition");
        this.knockbackResistanceAddition = builder.defineInRange("knockbackResistanceAddition", 0.2, 0.0, 1.0);
    }
}

