/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.LeechingAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class LeechAspect
extends AbstractAspect {
    private ForgeConfigSpec.IntValue leechCooldown;
    private ForgeConfigSpec.DoubleValue leechRange;
    private ForgeConfigSpec.DoubleValue leechHealPercent;

    public LeechAspect() {
        super(new LeechingAspectHandler());
    }

    @Override
    public void applyConfigToHandler() {
        ((LeechingAspectHandler)this.handler).setValues((Integer)this.leechCooldown.get(), ((Double)this.leechRange.get()).floatValue(), ((Double)this.leechHealPercent.get()).floatValue());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.LEECH;
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Cooldown of leech ability (in ticks , normally 20 ticks = 1 second) ");
        this.leechCooldown = builder.defineInRange("leechCooldown", 100, 1, Integer.MAX_VALUE);
        builder.comment("Radius of leech");
        this.leechRange = builder.defineInRange("leechRadius", 5.0, 0.1, 128.0);
        builder.comment("Percentage of health restoration when used leech");
        this.leechHealPercent = builder.defineInRange("leechHealPercent", 0.1, 0.01, 1.0);
    }
}

