/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.SirenAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class SirenAspect
extends AbstractAspect {
    private ForgeConfigSpec.IntValue sirenLureCount;
    private ForgeConfigSpec.DoubleValue sirenLureRadius;
    private ForgeConfigSpec.DoubleValue sirenUseChance;

    public SirenAspect() {
        super(new SirenAspectHandler());
    }

    @Override
    public void applyConfigToHandler() {
        ((SirenAspectHandler)this.handler).setConfig(((Double)this.sirenLureRadius.get()).floatValue(), ((Double)this.sirenUseChance.get()).floatValue(), (Integer)this.sirenLureCount.get());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.SIREN;
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Chance that will lure mobs when took hit");
        this.sirenUseChance = builder.defineInRange("sirenUseChance", 0.5, 0.01, 1.0);
        builder.comment("Amount of mobs that will be attracted");
        this.sirenLureCount = builder.defineInRange("sirenLureCount", 2, 1, 10);
        builder.comment("Range of mobs that will be attracted");
        this.sirenLureRadius = builder.defineInRange("sirenLureRadius", 32.0, 16.0, 64.0);
    }
}

