/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.UndyingAuraAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class UndyingAuraAspect
extends AbstractAspect {
    private ForgeConfigSpec.IntValue undyingAuraCooldown;
    private ForgeConfigSpec.IntValue undyingAuraDuration;
    private ForgeConfigSpec.IntValue undyingAuraEffectDuration;
    private ForgeConfigSpec.DoubleValue undyingAuraRange;
    private ForgeConfigSpec.DoubleValue undyingAuraForceUseBelowHealth;

    public UndyingAuraAspect() {
        super(new UndyingAuraAspectHandler());
    }

    @Override
    public void applyConfigToHandler() {
        ((UndyingAuraAspectHandler)this.handler).setConfig((Integer)this.undyingAuraCooldown.get(), (Integer)this.undyingAuraDuration.get(), (Integer)this.undyingAuraEffectDuration.get(), ((Double)this.undyingAuraRange.get()).floatValue(), ((Double)this.undyingAuraForceUseBelowHealth.get()).floatValue());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.UNDYING_AURA;
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Intervals between activation (in ticks , normally 20 ticks = 1 second) ");
        this.undyingAuraCooldown = builder.defineInRange("ghastBuddyFireCooldown", 600, 20, Integer.MAX_VALUE);
        builder.comment("How long the aura exists per activation (in ticks , normally 20 ticks = 1 second) ");
        this.undyingAuraDuration = builder.defineInRange("undyingAuraDuration", 120, 10, Integer.MAX_VALUE);
        builder.comment("Force to activate the aura once when falling below the specified health percentage");
        this.undyingAuraForceUseBelowHealth = builder.defineInRange("undyingAuraForceUseBelowHealth", 0.5, 0.01, 1.0);
        builder.comment("Radius of the aura");
        this.undyingAuraRange = builder.defineInRange("undyingAuraRange", 5.0, 1.0, 16.0);
        builder.comment("Duration of the 'Undying' effect (in ticks , normally 20 ticks = 1 second) ");
        this.undyingAuraEffectDuration = builder.defineInRange("undyingAuraEffectDuration", 20, 10, Integer.MAX_VALUE);
    }
}

