/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.core;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.config.ServerConfig;
import com.mz.mobaspects.constants.AspectEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class AspectManager {
    public static final AspectManager INSTANCE = new AspectManager();
    private HashMap<AspectEnum, AbstractAspect> availableAspectMap;
    private List<AspectEnum> enabledAspectEnumList;

    private AspectManager() {
    }

    public void InitializeAspectList() {
        this.availableAspectMap = new HashMap();
        for (AbstractAspect aspect : ServerConfig.allAspectList) {
            if (!aspect.isEnabled()) continue;
            this.availableAspectMap.put(aspect.getCode(), aspect);
            aspect.applyConfigToHandler();
        }
        this.enabledAspectEnumList = new ArrayList<AspectEnum>(this.availableAspectMap.keySet());
    }

    public boolean canAttachAspect(Entity entity) {
        return entity instanceof Mob;
    }

    public Set<AspectEnum> rollAspect(Mob entity) {
        if (entity.m_21187_().nextFloat() > ((Double)ServerConfig.BASE_ASPECT_CHANCE.get()).floatValue()) {
            return new HashSet<AspectEnum>();
        }
        HashSet<AspectEnum> result = new HashSet<AspectEnum>();
        ArrayList<AspectEnum> clonedShuffleList = new ArrayList<AspectEnum>(this.enabledAspectEnumList);
        Collections.shuffle(clonedShuffleList);
        for (AspectEnum aspectEnum : clonedShuffleList) {
            result.add(aspectEnum);
            if (!(entity.m_21187_().nextFloat() > ((Double)ServerConfig.NEXT_ASPECT_CHANCE.get()).floatValue())) continue;
            break;
        }
        return result;
    }

    public AbstractAspect getAspect(AspectEnum code) {
        return this.availableAspectMap.get((Object)code);
    }
}

