/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class MoveTowardsSirenEntityGoal
extends Goal {
    private final Mob mob;
    private LivingEntity targetEntity;
    private int prevEntityId = 0;
    private final double speed;

    public MoveTowardsSirenEntityGoal(Mob creature, double speedIn) {
        this.mob = creature;
        this.speed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return !this.mob.m_20159_() && this.hasSirenTarget() && this.mob.m_5448_() == null;
    }

    public boolean m_8045_() {
        if (this.mob.m_20159_() || this.mob.m_5448_() != null || this.mob.m_21573_().m_26571_()) {
            return false;
        }
        this.checkAndSetTarget();
        return this.targetEntity != null && !this.mob.m_21573_().m_26572_() && this.targetEntity.m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.targetEntity = null;
        this.prevEntityId = 0;
        this.mob.getPersistentData().m_128405_("mobaspects_SirenMoveToId", 0);
    }

    public void m_8056_() {
        this.checkAndSetTarget();
    }

    public void m_8037_() {
        this.checkAndSetTarget();
        if (this.targetEntity != null && this.targetEntity.m_6084_()) {
            this.mob.m_21573_().m_5624_((Entity)this.targetEntity, this.speed);
        }
    }

    private boolean hasSirenTarget() {
        int targetEntityId = this.mob.getPersistentData().m_128451_("mobaspects_SirenMoveToId");
        if (targetEntityId == 0) {
            return false;
        }
        return this.mob.getPersistentData().m_128451_("mobaspects_SirenMoveToId") != 0;
    }

    private void checkAndSetTarget() {
        int targetEntityId = this.mob.getPersistentData().m_128451_("mobaspects_SirenMoveToId");
        if (targetEntityId == 0) {
            this.targetEntity = null;
            return;
        }
        if (this.prevEntityId == targetEntityId) {
            return;
        }
        this.prevEntityId = targetEntityId;
        if (targetEntityId != 0) {
            Entity entity = this.mob.f_19853_.m_6815_(targetEntityId);
            if (entity instanceof LivingEntity) {
                this.targetEntity = (LivingEntity)entity;
                this.mob.m_21573_().m_5624_((Entity)this.targetEntity, this.speed);
            }
        } else {
            this.targetEntity = null;
        }
    }
}

