/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class BerryAspectHandler
implements IAspectHandler {
    private float plantOnHitChance = 0.2f;
    private boolean canDropBerryOnReceiveHit = true;
    private boolean canPlantBerryOnDeath = true;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        Mob mob = (Mob)entity;
        mob.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42780_));
    }

    @Override
    public void handleOnDeath(LivingEntity entity, LivingDeathEvent evt) {
        if (evt.isCanceled()) {
            return;
        }
        if (this.canPlantBerryOnDeath) {
            this.plantBerryOnEntity((Entity)entity);
        }
    }

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        if (this.canDropBerryOnReceiveHit) {
            Utils.dropItemIntoWorld(victim.m_183503_(), victim.m_142538_(), new ItemStack((ItemLike)Items.f_42780_, 1 + victim.m_21187_().nextInt(4)));
        }
    }

    @Override
    public void handleOnHit(LivingEntity attacker, LivingEntity victim, float amount, DamageSource damageSource) {
        if (victim.m_21187_().nextFloat() <= this.plantOnHitChance) {
            this.plantBerryOnEntity((Entity)victim);
        }
    }

    private void plantBerryOnEntity(Entity entity) {
        BlockPos posBelow = entity.m_142538_().m_7495_();
        BlockState bsBelow = entity.m_183503_().m_8055_(posBelow);
        if (!bsBelow.m_60767_().m_76333_()) {
            return;
        }
        BlockPos posCurrent = entity.m_142538_();
        BlockState bsCurrent = entity.m_183503_().m_8055_(posCurrent);
        if (bsCurrent.m_60734_() instanceof AirBlock) {
            entity.m_183503_().m_7731_(posCurrent, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(2)), 2);
        }
    }

    public void setConfig(float plantOnHitChance, boolean canDropBerryOnReceiveHit, boolean canPlantBerryOnDeath) {
        this.plantOnHitChance = plantOnHitChance;
        this.canDropBerryOnReceiveHit = canDropBerryOnReceiveHit;
        this.canPlantBerryOnDeath = canPlantBerryOnDeath;
    }
}

