/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.util.Utils;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class DamageTransferAspectHandler
implements IAspectHandler {
    private float range = 3.0f;
    private float transferPercent = 0.5f;

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        Level world = victim.m_183503_();
        if (world.f_46443_ || amount <= 0.0f) {
            return;
        }
        List<Mob> mobEntityList = Utils.findNearbyEntityClass((Entity)victim, victim.m_183503_(), this.range);
        float amountToTransfer = amount * this.transferPercent;
        boolean isDamageTransferred = false;
        for (Mob mob : mobEntityList) {
            boolean hasDamageTransfer;
            if (!mob.m_6084_() || mob.m_142049_() == victim.m_142049_() || (hasDamageTransfer = mob.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).map(IAspectMob::getAspectCodes).filter(list -> list.contains((Object)AspectEnum.DAMAGE_TRANSFER)).isPresent())) continue;
            mob.m_6469_(damageSource, amountToTransfer);
            isDamageTransferred = true;
            break;
        }
        if (isDamageTransferred) {
            evt.setAmount(amount - amountToTransfer);
        }
    }

    public void setConfig(float range, float transferPercent) {
        this.range = range;
        this.transferPercent = transferPercent;
    }
}

