/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.CustomDamageSource;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.entity.OverloadCrystalEntity;
import com.mz.mobaspects.util.Utils;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class OverloadAspectHandler
implements IAspectHandler {
    private int maxHits = 4;
    private int ticksToReduceHitCount = 50;
    private int ticksBeforeExplosion = 100;
    private float explosionRadius = 5.0f;
    private boolean countHitsFromPlayerOnly = true;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        Mob mob = (Mob)entity;
        OverloadCrystalEntity followerEntity = new OverloadCrystalEntity((EntityType)CustomEntityRegister.OVERLOAD_CRYSTAL.get(), entity.f_19853_);
        followerEntity.setup(mob);
        followerEntity.setConfig(this.maxHits, this.ticksToReduceHitCount, this.ticksBeforeExplosion, this.explosionRadius);
        Utils.queueFollowerEntitySpawn(entity.f_19853_, followerEntity, (Mob)entity);
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        if (CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(evt.getSource())) {
            return;
        }
        if (this.countHitsFromPlayerOnly && !(evt.getSource().m_7639_() instanceof Player)) {
            return;
        }
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.getAspectFollowers().stream().filter(followerEntity -> followerEntity instanceof OverloadCrystalEntity).findFirst().map(followerEntity -> (OverloadCrystalEntity)((Object)((Object)followerEntity))).ifPresent(OverloadCrystalEntity::takeHit));
    }

    public void setConfig(int maxHits, int ticksToReduceHitCount, int ticksBeforeExplosion, float explosionRadius, boolean countHitsFromPlayerOnly) {
        this.maxHits = maxHits;
        this.ticksToReduceHitCount = ticksToReduceHitCount;
        this.ticksBeforeExplosion = ticksBeforeExplosion;
        this.explosionRadius = explosionRadius;
        this.countHitsFromPlayerOnly = countHitsFromPlayerOnly;
    }
}

