/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.CustomDamageSource;
import com.mz.mobaspects.entity.AspectShieldEntity;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.util.Utils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ShieldingAspectHandler
implements IAspectHandler {
    private int cooldown = 100;
    private boolean countHitsFromPlayerOnly = true;
    private boolean instantDestroyByAxe = true;
    private int maxHits = 3;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        Mob mob = (Mob)entity;
        AspectShieldEntity followerEntity = new AspectShieldEntity((EntityType)CustomEntityRegister.ASPECT_SHIELD.get(), entity.f_19853_);
        followerEntity.setup(mob);
        followerEntity.setConfig(this.maxHits, this.cooldown);
        Utils.queueFollowerEntitySpawn(entity.f_19853_, followerEntity, (Mob)entity);
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        if (CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(evt.getSource()) || evt.isCanceled()) {
            return;
        }
        if (this.countHitsFromPlayerOnly && !(evt.getSource().m_7639_() instanceof Player)) {
            return;
        }
        boolean isAxe = this.instantDestroyByAxe && this.isDamageByAxe(evt.getSource().m_7640_());
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.getAspectFollowers().stream().filter(followerEntity -> followerEntity instanceof AspectShieldEntity).findFirst().map(followerEntity -> (AspectShieldEntity)((Object)((Object)followerEntity))).filter(AspectShieldEntity::isActive).ifPresent(shield -> {
            shield.takeHit(isAxe);
            evt.setCanceled(true);
        }));
    }

    private boolean isDamageByAxe(Entity damageCauser) {
        if (!(damageCauser instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)damageCauser;
        return living.m_21205_().m_41720_() instanceof AxeItem;
    }

    public void setConfig(int maxHits, int cooldown, boolean instantDestroyByAxe, boolean countHitsFromPlayerOnly) {
        this.instantDestroyByAxe = instantDestroyByAxe;
        this.cooldown = cooldown;
        this.maxHits = maxHits;
        this.countHitsFromPlayerOnly = countHitsFromPlayerOnly;
    }
}

