/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class SirenAspectHandler
implements IAspectHandler {
    private float sirenLureRadius = 32.0f;
    private float sirenUseChance = 0.5f;
    private int sirenLureCount = 2;

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        if (!(victim instanceof Mob)) {
            return;
        }
        if (victim.m_21187_().nextDouble() > (double)this.sirenUseChance) {
            return;
        }
        List<Mob> nearByMobs = Utils.findNearbyEntityClass((Entity)((Mob)victim), victim.m_183503_(), this.sirenLureRadius);
        if (nearByMobs.size() == 0) {
            return;
        }
        victim.m_5496_(SoundEvents.f_11850_, 0.9f, 2.0f);
        Collections.shuffle(nearByMobs);
        for (int i = 0; i < nearByMobs.size() && i < this.sirenLureCount; ++i) {
            Mob mob = nearByMobs.get(i);
            mob.getPersistentData().m_128405_("mobaspects_SirenMoveToId", victim.m_142049_());
        }
    }

    public void setConfig(float sirenLureRadius, float sirenUseChance, int sirenLureCount) {
        this.sirenLureRadius = sirenLureRadius;
        this.sirenUseChance = sirenUseChance;
        this.sirenLureCount = sirenLureCount;
    }
}

