/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.goal.StoicTakeDamageGoal;
import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.constants.CustomDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class StoicAspectHandler
implements IAspectHandler {
    public static String NBT_STOIC_DAMAGE_POOL = "STOIC_DAMAGE_POOL";
    private float maxDamageCanTake = 8.0f;
    private int ticksPerTakeDamage = 20;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        Mob mob = (Mob)entity;
        mob.f_21345_.m_25352_(0, (Goal)new StoicTakeDamageGoal(mob, this.ticksPerTakeDamage, this.maxDamageCanTake));
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        DamageSource source = evt.getSource();
        if (!CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(source)) {
            float amount = evt.getAmount();
            float damage = victim.getPersistentData().m_128457_(NBT_STOIC_DAMAGE_POOL);
            victim.getPersistentData().m_128350_(NBT_STOIC_DAMAGE_POOL, damage += amount);
            evt.setAmount(0.0f);
        }
    }

    public void setConfig(float maxDamageCanTake, int ticksPerTakeDamage) {
        this.maxDamageCanTake = maxDamageCanTake;
        this.ticksPerTakeDamage = ticksPerTakeDamage;
    }
}

