/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.capability;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.MobAspectMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class CapabilityEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (AspectManager.INSTANCE.canAttachAspect(entity)) {
            AspectCapabilityProvider provider = new AspectCapabilityProvider((LivingEntity)entity);
            evt.addCapability(new ResourceLocation("mobaspects", "mobaspects"), (ICapabilityProvider)provider);
            evt.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        Player playerEntity = evt.getPlayer();
        if (!(playerEntity instanceof ServerPlayer)) {
            return;
        }
        entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerEntity), (Object)new MobAspectMessage(entity, (IAspectMob)aspectMob)));
    }
}

