/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.capability.aspect;

import com.mz.mobaspects.aspect.core.AspectMob;
import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.constants.AspectEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AspectCapabilityProvider
implements ICapabilitySerializable<Tag> {
    public static Capability<IAspectMob> ASPECT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAspectMob>(){});
    final LazyOptional<IAspectMob> optional;
    final IAspectMob dto;

    public AspectCapabilityProvider(LivingEntity livingEntity) {
        this.dto = new AspectMob(livingEntity);
        this.optional = LazyOptional.of(() -> this.dto);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
        return capability == ASPECT_CAPABILITY ? this.optional.cast() : LazyOptional.empty();
    }

    public Tag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        Set<AspectEnum> aspectCodeList = this.dto.getAspectCodes();
        compoundNBT.m_128408_("mobaspects_attributes", AspectCapabilityProvider.aspectEnumToId(aspectCodeList));
        return compoundNBT;
    }

    public void deserializeNBT(Tag nbt) {
        CompoundTag compoundNBT = (CompoundTag)nbt;
        if (compoundNBT.m_128441_("mobaspects_attributes")) {
            int[] codeArray = compoundNBT.m_128465_("mobaspects_attributes");
            this.dto.setAspectCodes(AspectCapabilityProvider.aspectIdToEnum(codeArray));
        }
    }

    public void invalidate() {
        this.optional.invalidate();
    }

    private static List<Integer> aspectEnumToId(Collection<AspectEnum> aspectCodeList) {
        return aspectCodeList.stream().map(AspectEnum::getId).collect(Collectors.toList());
    }

    private static Set<AspectEnum> aspectIdToEnum(int[] aspectIdAry) {
        return Arrays.stream(aspectIdAry).mapToObj(AspectEnum::fromId).collect(Collectors.toSet());
    }
}

