/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.config;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.aspects.BerryAspect;
import com.mz.mobaspects.aspect.aspects.BerserkAspect;
import com.mz.mobaspects.aspect.aspects.CreeperAspect;
import com.mz.mobaspects.aspect.aspects.DamageTransferAspect;
import com.mz.mobaspects.aspect.aspects.DamagingEffectAspect;
import com.mz.mobaspects.aspect.aspects.DebuffAspect;
import com.mz.mobaspects.aspect.aspects.EndermanAspect;
import com.mz.mobaspects.aspect.aspects.ExtraLifeAspect;
import com.mz.mobaspects.aspect.aspects.GhastBuddyAspect;
import com.mz.mobaspects.aspect.aspects.GlassCanonAspect;
import com.mz.mobaspects.aspect.aspects.HeavyAspect;
import com.mz.mobaspects.aspect.aspects.LeechAspect;
import com.mz.mobaspects.aspect.aspects.OverloadAspect;
import com.mz.mobaspects.aspect.aspects.ParasiteAspect;
import com.mz.mobaspects.aspect.aspects.RiderAspect;
import com.mz.mobaspects.aspect.aspects.ShieldingAspect;
import com.mz.mobaspects.aspect.aspects.SirenAspect;
import com.mz.mobaspects.aspect.aspects.StickyBombAspect;
import com.mz.mobaspects.aspect.aspects.StoicAspect;
import com.mz.mobaspects.aspect.aspects.SwapAspect;
import com.mz.mobaspects.aspect.aspects.SwiftAspect;
import com.mz.mobaspects.aspect.aspects.UndyingAuraAspect;
import com.mz.mobaspects.aspect.aspects.VampireAspect;
import com.mz.mobaspects.aspect.aspects.VengenanceAspect;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_ASPECT_COUNT;
    public static final ForgeConfigSpec.DoubleValue XP_MULTIPLIER_PER_ASPECT;
    public static final ForgeConfigSpec.DoubleValue BASE_ASPECT_CHANCE;
    public static final ForgeConfigSpec.DoubleValue NEXT_ASPECT_CHANCE;
    public static final List<AbstractAspect> allAspectList;

    static {
        allAspectList = new ArrayList<AbstractAspect>();
        allAspectList.add(new BerryAspect());
        allAspectList.add(new BerserkAspect());
        allAspectList.add(new CreeperAspect());
        allAspectList.add(new DamageTransferAspect());
        allAspectList.add(new DamagingEffectAspect());
        allAspectList.add(new DebuffAspect());
        allAspectList.add(new EndermanAspect());
        allAspectList.add(new ExtraLifeAspect());
        allAspectList.add(new GhastBuddyAspect());
        allAspectList.add(new GlassCanonAspect());
        allAspectList.add(new HeavyAspect());
        allAspectList.add(new LeechAspect());
        allAspectList.add(new OverloadAspect());
        allAspectList.add(new ParasiteAspect());
        allAspectList.add(new RiderAspect());
        allAspectList.add(new SirenAspect());
        allAspectList.add(new ShieldingAspect());
        allAspectList.add(new StickyBombAspect());
        allAspectList.add(new StoicAspect());
        allAspectList.add(new SwapAspect());
        allAspectList.add(new SwiftAspect());
        allAspectList.add(new VampireAspect());
        allAspectList.add(new VengenanceAspect());
        allAspectList.add(new UndyingAuraAspect());
        BUILDER.push("mobaspects");
        BUILDER.comment("Maximum aspects a mob can have (-1 = unlimited)");
        MAX_ASPECT_COUNT = BUILDER.define("maxAspects", (Object)-1);
        BUILDER.comment("XP multiplier per aspect count");
        XP_MULTIPLIER_PER_ASPECT = BUILDER.defineInRange("xpMultiplier", 1.5, 1.0, Double.MAX_VALUE);
        BUILDER.comment("Base chance for a mob to have at least 1 aspect ( e.g 0.5 = 50% )");
        BASE_ASPECT_CHANCE = BUILDER.defineInRange("baseChance", 0.5, 0.0, 1.0);
        BUILDER.comment("The chance for a mob to have next aspect ( e.g chance of having 2 aspects = 0.5 base * 0.5 next  = 0.25 (25%)  )");
        NEXT_ASPECT_CHANCE = BUILDER.defineInRange("nextChance", 0.5, 0.0, 1.0);
        for (AbstractAspect aspect : allAspectList) {
            aspect.buildConfig(BUILDER);
        }
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

