/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class AspectShieldEntity
extends AbstractAspectFollowerEntity {
    private int nextUse = 0;
    private int cooldown = 160;
    private int currentHits = 0;
    private int maxHits = 3;
    private boolean canRender = true;
    private final ItemStack shieldItemStack = new ItemStack((ItemLike)Items.f_42740_, 1);

    public AspectShieldEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void setConfig(int maxHits, int cooldown) {
        this.cooldown = cooldown;
        this.maxHits = maxHits;
    }

    @Override
    protected void tickServer() {
        this.tickCooldown();
    }

    public void takeHit(boolean isAxe) {
        if (this.currentHits >= this.maxHits) {
            return;
        }
        this.currentHits = isAxe ? this.maxHits : (this.currentHits = this.currentHits + 1);
        this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
        if (this.currentHits >= this.maxHits) {
            this.nextUse = this.cooldown;
            this.m_5496_(SoundEvents.f_12347_, 1.0f, 1.0f);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.SHIELD_BREAK));
        }
    }

    private void tickCooldown() {
        if (this.currentHits < this.maxHits) {
            return;
        }
        --this.nextUse;
        if (this.nextUse <= 0) {
            this.currentHits = 0;
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.SHIELD_ACTIVE));
        }
    }

    public boolean isActive() {
        return this.currentHits < this.maxHits;
    }

    public void clientSideShieldBreak() {
        this.canRender = false;
        for (int i = 0; i < 5; ++i) {
            this.addBreakParticle();
        }
    }

    public void clientSideShieldActive() {
        this.canRender = true;
    }

    private void addBreakParticle() {
        Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
        vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
        double d0 = (double)(-this.f_19796_.nextFloat()) * 0.6 - 0.3;
        Vec3 vec31 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.3, d0, 0.6);
        vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
        this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.shieldItemStack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
    }

    public boolean canRender() {
        return this.canRender;
    }
}

