/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class OverloadCrystalEntity
extends AbstractAspectFollowerEntity {
    private int currentHits = 0;
    private int maxHits = 5;
    private int currentTicksToReduceHitCount = 0;
    private int ticksToReduceHitCount = 50;
    private boolean fused = false;
    private int currentTicksBeforeExplosion = 0;
    private int ticksBeforeExplosion = 100;
    private float explosionRadius = 5.0f;
    private int innerRotation;

    public OverloadCrystalEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void setConfig(int maxHits, int ticksToReduceHitCount, int ticksBeforeExplosion, float explosionRadius) {
        this.maxHits = maxHits;
        this.ticksToReduceHitCount = ticksToReduceHitCount;
        this.ticksBeforeExplosion = ticksBeforeExplosion;
        this.explosionRadius = explosionRadius;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.innerRotation;
    }

    @Override
    protected void tickServer() {
        this.tickExplode();
        this.tickReduceHitCount();
    }

    public void takeHit() {
        if (this.fused) {
            return;
        }
        ++this.currentHits;
        if (this.currentHits >= this.maxHits) {
            this.fused = true;
            this.m_5496_(SoundEvents.f_11837_, 1.0f, 1.0f);
            this.sendUpdateMessage(true);
        }
    }

    private void tickExplode() {
        if (!this.fused) {
            return;
        }
        ++this.currentTicksBeforeExplosion;
        if (this.currentTicksBeforeExplosion >= this.ticksBeforeExplosion) {
            this.fused = false;
            this.currentTicksBeforeExplosion = 0;
            this.currentHits = 0;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Explosion.BlockInteraction.NONE);
            this.sendUpdateMessage(false);
        }
    }

    private void tickReduceHitCount() {
        if (this.currentHits <= 0 || this.fused) {
            return;
        }
        ++this.currentTicksToReduceHitCount;
        if (this.currentTicksToReduceHitCount >= this.ticksToReduceHitCount) {
            --this.currentHits;
            this.currentTicksToReduceHitCount = 0;
        }
    }

    private void sendUpdateMessage(boolean isFused) {
        if (isFused) {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_ON));
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_OFF));
        }
    }

    public boolean isFused() {
        return this.fused;
    }

    public void setFused(boolean fused) {
        this.fused = fused;
    }

    public int getInnerRotation() {
        return this.innerRotation;
    }
}

