/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.MobAspectMessage;
import com.mz.mobaspects.util.EntityAttributeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class ParasiteEntity
extends Monster
implements Enemy {
    private static final UUID KNOCKBACK_MODIFIER_IDENTIFIER = UUID.fromString("9b5b0d49-3666-4f3e-b836-ac62ea229a8e");
    private LivingEntity mobAttaching;
    private int currentTicks = 0;
    private int ticksToAttach = 60;
    private Set<AspectEnum> carryingAspects = new HashSet<AspectEnum>();

    public ParasiteEntity(EntityType<? extends ParasiteEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void setup(Set<AspectEnum> carryingAspects, int ticksToAttach) {
        this.carryingAspects = carryingAspects;
        this.ticksToAttach = ticksToAttach;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true));
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.mobAttaching != null) {
            return true;
        }
        if (entityIn instanceof ParasiteEntity) {
            return true;
        }
        if (entityIn instanceof Mob) {
            this.mobAttaching = (Mob)entityIn;
            this.mobAttaching.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120));
            EntityAttributeUtils.ApplyAttributeModifier(this.mobAttaching, Attributes.f_22278_, KNOCKBACK_MODIFIER_IDENTIFIER, 1.0f, AttributeModifier.Operation.ADDITION, "Parasite knockback immune");
            EntityAttributeUtils.ApplyAttributeModifier((LivingEntity)this, Attributes.f_22278_, KNOCKBACK_MODIFIER_IDENTIFIER, 1.0f, AttributeModifier.Operation.ADDITION, "Parasite knockback immune");
        }
        return true;
    }

    private void attachToMob() {
        this.mobAttaching.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            HashSet<AspectEnum> aspectsToAdd = new HashSet<AspectEnum>(this.carryingAspects);
            aspectsToAdd.removeAll(aspectMob.getAspectCodes());
            aspectsToAdd.forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnSpawn(this.mobAttaching));
            aspectMob.getAspectCodes().addAll(aspectsToAdd);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MobAspectMessage(this.mobAttaching.m_142049_(), aspectMob.getAspectCodes()));
        });
        EntityAttributeUtils.removeAttributeModifier(this.mobAttaching, Attributes.f_22278_, KNOCKBACK_MODIFIER_IDENTIFIER);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        if (!this.f_19853_.f_46443_) {
            if (this.mobAttaching != null && !this.mobAttaching.m_6084_()) {
                this.mobAttaching = null;
                EntityAttributeUtils.removeAttributeModifier((LivingEntity)this, Attributes.f_22278_, KNOCKBACK_MODIFIER_IDENTIFIER);
                this.currentTicks = 0;
            } else if (this.m_6084_() && this.mobAttaching != null && this.currentTicks < this.ticksToAttach) {
                ++this.currentTicks;
                if (this.currentTicks >= this.ticksToAttach) {
                    this.attachToMob();
                }
            }
        }
        super.m_8119_();
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.13f;
    }

    public static AttributeSupplier setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22265_();
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11853_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11855_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11854_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11856_, 0.15f, 1.0f);
    }

    public void m_5618_(float pOffset) {
        this.m_146922_(pOffset);
        super.m_5618_(pOffset);
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }
}

