/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.effects.CustomEffectRegistry;
import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import com.mz.mobaspects.util.Utils;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class UndyingTotemAspectEntity
extends AbstractAspectFollowerEntity {
    private int abilityNextUse = 120;
    private int abilityCooldown = 120;
    private int abilityDurationRemain = 0;
    private int abilityDuration = 120;
    private int effectDuration = 20;
    private float range = 5.0f;
    private boolean isAuraActive = false;
    private boolean forceActivated = false;

    public UndyingTotemAspectEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void setConfig(int abilityCooldown, int abilityDuration, int effectDuration, float range) {
        this.abilityCooldown = abilityCooldown;
        this.abilityDuration = abilityDuration;
        this.effectDuration = effectDuration;
        this.range = range;
        this.abilityNextUse = abilityCooldown;
    }

    @Override
    protected void tickServer() {
        this.checkAndUseAbility();
    }

    public void forceActivate() {
        if (this.forceActivated) {
            return;
        }
        this.forceActivated = true;
        this.activateAura();
    }

    public void activateAura() {
        this.abilityDurationRemain = this.abilityDuration;
        this.isAuraActive = true;
        this.sendUpdateMessage(true);
    }

    private void checkAndUseAbility() {
        if (this.isAuraActive) {
            --this.abilityDurationRemain;
            this.applyAuraEffect();
            if (this.abilityDurationRemain <= 0) {
                this.isAuraActive = false;
                this.sendUpdateMessage(false);
                this.abilityNextUse = this.abilityCooldown;
            }
        } else {
            if (this.abilityNextUse > 0) {
                --this.abilityNextUse;
                return;
            }
            this.activateAura();
        }
    }

    private void applyAuraEffect() {
        List<LivingEntity> nearbyLivingEntities = Utils.findNearbyLivingEntities(this, this.f_19853_, this.range);
        if (nearbyLivingEntities.size() == 0) {
            return;
        }
        for (LivingEntity livingEntity : nearbyLivingEntities) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)CustomEffectRegistry.UNDYING.get(), this.effectDuration));
        }
    }

    private void sendUpdateMessage(boolean isAuraActive) {
        if (isAuraActive) {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.UNDYING_TOTEM_ACTIVE));
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.m_142049_(), EntityActionEnum.UNDYING_TOTEM_DEACTIVE));
        }
    }

    public boolean isAuraActive() {
        return this.isAuraActive;
    }

    public void setAuraActive(boolean isAuraActive) {
        this.isAuraActive = isAuraActive;
    }

    public float getRange() {
        return this.range;
    }
}

