/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.events;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.aspect.goal.MoveTowardsSirenEntityGoal;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.config.ServerConfig;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.effects.CustomEffectRegistry;
import com.mz.mobaspects.entity.ParasiteEntity;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AspectEventHandler {
    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (!(entity instanceof Monster) || entity instanceof ParasiteEntity || entity.f_19853_.f_46443_) {
            return;
        }
        ((Monster)entity).f_21345_.m_25352_(0, (Goal)new MoveTowardsSirenEntityGoal((Mob)((Monster)entity), 1.0));
        entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            Set<AspectEnum> aspectList = AspectManager.INSTANCE.rollAspect((Mob)((Monster)entity));
            aspectMob.setAspectCodes(aspectList);
            aspectMob.getAspectCodes().forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnSpawn((LivingEntity)entity));
        });
    }

    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        LivingEntity victim = evt.getEntityLiving();
        if (victim.f_19853_.f_46443_) {
            return;
        }
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.getAspectCodes().forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handlePreReceiveHit(victim, evt)));
    }

    public void onLivingAttack(LivingAttackEvent evt) {
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        LivingEntity victim = evt.getEntityLiving();
        Entity attacker = evt.getSource().m_7639_();
        if (victim.f_19853_.f_46443_) {
            return;
        }
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.getAspectCodes().forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnReceiveHitServer(attacker, victim, evt.getAmount(), evt.getSource(), evt)));
        if (!(attacker instanceof LivingEntity) || attacker.f_19853_.f_46443_) {
            return;
        }
        attacker.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.getAspectCodes().forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnHit((LivingEntity)attacker, victim, evt.getAmount(), evt.getSource())));
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity victim = evt.getEntityLiving();
        if (victim.f_19853_.f_46443_) {
            return;
        }
        if (victim.m_21023_((MobEffect)CustomEffectRegistry.UNDYING.get())) {
            victim.m_21153_(0.1f);
            evt.setCanceled(true);
        }
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.getAspectCodes().forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnDeath(victim, evt)));
    }

    @SubscribeEvent
    public void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity.f_19853_.f_46443_) {
            return;
        }
        livingEntity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            float totalMultiplier = ((Double)ServerConfig.XP_MULTIPLIER_PER_ASPECT.get()).floatValue() * (float)aspectMob.getAspectCodes().size();
            totalMultiplier = totalMultiplier <= 0.0f ? 1.0f : totalMultiplier;
            int newExp = (int)((float)evt.getOriginalExperience() * totalMultiplier);
            evt.setDroppedExperience(newExp);
        });
    }
}

