/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.events.gui;

import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.util.RaytraceHelper;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UiEventHandler {
    private static final String TRANSLATION_PREFIX = "aspect.name.";

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (Minecraft.m_91087_().f_91066_.f_92062_ || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Optional<LivingEntity> livingEntity = RaytraceHelper.getLookAtMobAspect(mc, event.getPartialTicks());
        livingEntity.ifPresent(entity -> entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            Set<AspectEnum> aspectCodeList = aspectMob.getAspectCodes();
            if (aspectCodeList.size() == 0) {
                return;
            }
            int xOffset = (int)((double)mc.m_91268_().m_85445_() * 0.05);
            int yOffset = (int)((double)mc.m_91268_().m_85445_() * 0.05);
            for (AspectEnum aspect : aspectCodeList) {
                mc.f_91062_.m_92763_(event.getMatrixStack(), (Component)new TranslatableComponent(TRANSLATION_PREFIX + aspect.getName()), (float)xOffset, (float)yOffset, 0xFF0000);
                yOffset += 20;
            }
        }));
    }
}

