/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.network.message;

import com.mz.mobaspects.entity.AspectShieldEntity;
import com.mz.mobaspects.entity.OverloadCrystalEntity;
import com.mz.mobaspects.entity.UndyingTotemAspectEntity;
import com.mz.mobaspects.network.message.EntityActionEnum;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class EntityActionMessage {
    private int entityId;
    private EntityActionEnum entityActionEnum;

    public EntityActionMessage() {
    }

    public EntityActionMessage(int entityId, EntityActionEnum entityActionEnum) {
        this.entityId = entityId;
        this.entityActionEnum = entityActionEnum;
    }

    public static void encode(EntityActionMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_130068_((Enum)message.entityActionEnum);
    }

    public static EntityActionMessage decode(FriendlyByteBuf buffer) {
        EntityActionMessage message = new EntityActionMessage();
        message.entityId = buffer.readInt();
        message.entityActionEnum = (EntityActionEnum)buffer.m_130066_(EntityActionEnum.class);
        return message;
    }

    public static void handle(EntityActionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null) {
                EntityActionMessage.handleMessageContent(message, world);
            }
        });
        context.setPacketHandled(true);
    }

    private static void handleMessageContent(EntityActionMessage message, ClientLevel world) {
        Entity entity = world.m_6815_(message.entityId);
        if (entity == null) {
            return;
        }
        if (EntityActionEnum.UNDYING_TOTEM_ACTIVE == message.entityActionEnum) {
            if (!(entity instanceof UndyingTotemAspectEntity)) {
                return;
            }
            ((UndyingTotemAspectEntity)entity).setAuraActive(true);
        } else if (EntityActionEnum.UNDYING_TOTEM_DEACTIVE == message.entityActionEnum) {
            if (!(entity instanceof UndyingTotemAspectEntity)) {
                return;
            }
            ((UndyingTotemAspectEntity)entity).setAuraActive(false);
        } else if (EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_OFF == message.entityActionEnum) {
            if (!(entity instanceof OverloadCrystalEntity)) {
                return;
            }
            ((OverloadCrystalEntity)entity).setFused(false);
        } else if (EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_ON == message.entityActionEnum) {
            if (!(entity instanceof OverloadCrystalEntity)) {
                return;
            }
            ((OverloadCrystalEntity)entity).setFused(true);
        } else if (EntityActionEnum.SHIELD_BREAK == message.entityActionEnum) {
            if (!(entity instanceof AspectShieldEntity)) {
                return;
            }
            ((AspectShieldEntity)entity).clientSideShieldBreak();
        } else if (EntityActionEnum.SHIELD_ACTIVE == message.entityActionEnum) {
            if (!(entity instanceof AspectShieldEntity)) {
                return;
            }
            ((AspectShieldEntity)entity).clientSideShieldActive();
        }
    }
}

