/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.network.message;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MobAspectMessage {
    private int entityId;
    private int aspectCount;
    private Set<AspectEnum> aspectCodes;

    public MobAspectMessage() {
    }

    public MobAspectMessage(Entity entity, IAspectMob aspectMob) {
        this(entity.m_142049_(), aspectMob.getAspectCodes());
    }

    public MobAspectMessage(int entityId, Set<AspectEnum> aspectCodes) {
        this.entityId = entityId;
        this.aspectCount = aspectCodes.size();
        this.aspectCodes = aspectCodes;
    }

    public static void encode(MobAspectMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeInt(message.aspectCount);
        message.aspectCodes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130068_(arg_0));
    }

    public static MobAspectMessage decode(FriendlyByteBuf buffer) {
        MobAspectMessage message = new MobAspectMessage();
        message.entityId = buffer.readInt();
        message.aspectCount = buffer.readInt();
        message.aspectCodes = new HashSet<AspectEnum>();
        for (int i = 0; i < message.aspectCount; ++i) {
            message.aspectCodes.add((AspectEnum)buffer.m_130066_(AspectEnum.class));
        }
        return message;
    }

    public static void handle(MobAspectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (entity = world.m_6815_(message.entityId)) != null) {
                entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.setAspectCodes(message.aspectCodes));
            }
        });
        context.setPacketHandled(true);
    }
}

