/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.util;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;

public class Utils {
    public static List<Mob> findNearbyEntityClass(Entity source, Level world, float radius) {
        AABB range = new AABB(source.m_20185_() - (double)radius, source.m_20186_() - (double)radius, source.m_20189_() - (double)radius, source.m_20185_() + (double)radius, source.m_20186_() + (double)radius, source.m_20189_() + (double)radius);
        List MobList = world.m_45976_(Mob.class, range);
        if (source instanceof Mob) {
            MobList.remove(source);
        }
        return MobList;
    }

    public static List<LivingEntity> findNearbyLivingEntities(Entity source, Level world, float radius) {
        AABB range = new AABB(source.m_20185_() - (double)radius, source.m_20186_() - (double)radius, source.m_20189_() - (double)radius, source.m_20185_() + (double)radius, source.m_20186_() + (double)radius, source.m_20189_() + (double)radius);
        return world.m_45976_(LivingEntity.class, range);
    }

    public static boolean hasAspect(Mob mob, AspectEnum aspect) {
        return mob.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).filter(iAspectMob -> iAspectMob.getAspectCodes().contains((Object)aspect)).isPresent();
    }

    public static Set<AspectEnum> getAspects(LivingEntity entity) {
        return entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).map(IAspectMob::getAspectCodes).orElse(new HashSet());
    }

    public static void queueFollowerEntitySpawn(Level world, AbstractAspectFollowerEntity followerEntity, Mob ownerEntity) {
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(world.f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER);
        executor.m_6937_((Runnable)new TickTask(0, () -> {
            world.m_7967_((Entity)followerEntity);
            ownerEntity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.addAspectFollower(followerEntity));
        }));
    }

    public static float getHealthPercentage(LivingEntity entity) {
        return entity.m_21223_() / entity.m_21233_();
    }

    public static void dropItemIntoWorld(Level world, BlockPos pos, ItemStack item) {
        Random rand = new Random();
        if (item != null && item.m_41613_() > 0) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.m_123341_() + rx), (double)((float)pos.m_123342_() + ry), (double)((float)pos.m_123343_() + rz), item.m_41777_());
            if (item.m_41782_()) {
                entityItem.m_32055_().m_41751_(item.m_41783_().m_6426_());
            }
            float factor = 0.05f;
            entityItem.m_6001_(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
            world.m_7967_((Entity)entityItem);
            item.m_41764_(0);
        }
    }
}

