/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.BerryAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class BerryAspect
extends AbstractAspect {
    private ForgeConfigSpec.DoubleValue berryPlantOnHitChance;
    private ForgeConfigSpec.BooleanValue berryCanPlantOnDeath;
    private ForgeConfigSpec.BooleanValue berryCanDropOnReceiveHit;

    public BerryAspect() {
        super(new BerryAspectHandler());
    }

    @Override
    public void applyConfigToHandler() {
        ((BerryAspectHandler)this.handler).setConfig(((Double)this.berryPlantOnHitChance.get()).floatValue(), (Boolean)this.berryCanPlantOnDeath.get(), (Boolean)this.berryCanDropOnReceiveHit.get());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.BERRY;
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Chance that will plant a berry bush under the target hit");
        this.berryPlantOnHitChance = builder.defineInRange("berryPlantOnHitChance", 0.2, 0.0, 1.0);
        builder.comment("Can plant a berry bush when killed");
        this.berryCanPlantOnDeath = builder.define("berryCanPlantOnDeath", true);
        builder.comment("Can drop berry when receive hit");
        this.berryCanDropOnReceiveHit = builder.define("berryCanPlantOnDeath", true);
    }
}

