/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.StickyBombAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class StickyBombAspect
extends AbstractAspect {
    private ForgeConfigSpec.DoubleValue chance;
    private ForgeConfigSpec.DoubleValue explosionRadius;
    private ForgeConfigSpec.BooleanValue explosionDestructive;

    public StickyBombAspect() {
        super(new StickyBombAspectHandler());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.STICKY_BOMB;
    }

    @Override
    public void applyConfigToHandler() {
        ((StickyBombAspectHandler)this.handler).setConfig(((Double)this.chance.get()).floatValue(), ((Double)this.explosionRadius.get()).floatValue(), (Boolean)this.explosionDestructive.get());
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Explosion radius");
        this.explosionRadius = builder.defineInRange("explosionRadius", 4.0, 0.0, Double.MAX_VALUE);
        builder.comment("Explosion destroys blocks?");
        this.explosionDestructive = builder.define("explosionDestructive", false);
        builder.comment("Chance of applying sticky bomb");
        this.chance = builder.defineInRange("chance", 0.3, 0.01, 1.0);
    }
}

