/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.SwiftAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class SwiftAspect
extends AbstractAspect {
    private ForgeConfigSpec.DoubleValue speedMultiplier;
    private ForgeConfigSpec.DoubleValue attackSpeedMultiplier;

    public SwiftAspect() {
        super(new SwiftAspectHandler());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.SWIFT;
    }

    @Override
    public void applyConfigToHandler() {
        ((SwiftAspectHandler)this.handler).setConfig(((Double)this.speedMultiplier.get()).floatValue() - 1.0f, ((Double)this.attackSpeedMultiplier.get()).floatValue() - 1.0f);
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Speed multiplier");
        this.speedMultiplier = builder.defineInRange("speedMultiplier", 1.5, 1.0, 100.0);
        builder.comment("Attack speed multiplier");
        this.attackSpeedMultiplier = builder.defineInRange("attackSpeedMultiplier", 1.3, 1.0, 100.0);
    }
}

