/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.aspects;

import com.mz.mobaspects.aspect.aspects.AbstractAspect;
import com.mz.mobaspects.aspect.handler.VengeanceAspectHandler;
import com.mz.mobaspects.constants.AspectEnum;
import net.minecraftforge.common.ForgeConfigSpec;

public class VengenanceAspect
extends AbstractAspect {
    private ForgeConfigSpec.IntValue maxTeleportCount;
    private ForgeConfigSpec.DoubleValue radius;

    public VengenanceAspect() {
        super(new VengeanceAspectHandler());
    }

    @Override
    public void applyConfigToHandler() {
        ((VengeanceAspectHandler)this.handler).setConfig(((Double)this.radius.get()).floatValue(), (Integer)this.maxTeleportCount.get());
    }

    @Override
    public AspectEnum getCode() {
        return AspectEnum.VENGEANCE;
    }

    @Override
    protected void buildAspectSpecific(ForgeConfigSpec.Builder builder) {
        builder.comment("Max number of mobs that will be teleported");
        this.maxTeleportCount = builder.defineInRange("maxTeleportCount", 4, 1, 32);
        builder.comment("Radius of teleportation");
        this.radius = builder.defineInRange("radius", 25.0, 0.1, 128.0);
    }
}

