/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.Utils;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class BerryAspectHandler
implements IAspectHandler {
    private float plantOnHitChance = 0.2f;
    private boolean canDropBerryOnReceiveHit = true;
    private boolean canPlantBerryOnDeath = true;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        MobEntity mob = (MobEntity)entity;
        mob.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_222112_pR));
    }

    @Override
    public void handleOnDeath(LivingEntity entity, LivingDeathEvent evt) {
        if (evt.isCanceled()) {
            return;
        }
        if (this.canPlantBerryOnDeath) {
            this.plantBerryOnEntity((Entity)entity);
        }
    }

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        if (this.canDropBerryOnReceiveHit) {
            Utils.dropItemIntoWorld(victim.func_130014_f_(), victim.func_233580_cy_(), new ItemStack((IItemProvider)Items.field_222112_pR, 1 + victim.func_70681_au().nextInt(4)));
        }
    }

    @Override
    public void handleOnHit(LivingEntity attacker, LivingEntity victim, float amount, DamageSource damageSource) {
        if (victim.func_70681_au().nextFloat() <= this.plantOnHitChance) {
            this.plantBerryOnEntity((Entity)victim);
        }
    }

    private void plantBerryOnEntity(Entity entity) {
        BlockPos posBelow = entity.func_233580_cy_().func_177977_b();
        BlockState bsBelow = entity.func_130014_f_().func_180495_p(posBelow);
        if (!bsBelow.func_185904_a().func_76220_a()) {
            return;
        }
        BlockPos posCurrent = entity.func_233580_cy_();
        BlockState bsCurrent = entity.func_130014_f_().func_180495_p(posCurrent);
        if (bsCurrent.func_177230_c() instanceof AirBlock) {
            entity.func_130014_f_().func_180501_a(posCurrent, (BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(2)), 2);
        }
    }

    public void setConfig(float plantOnHitChance, boolean canDropBerryOnReceiveHit, boolean canPlantBerryOnDeath) {
        this.plantOnHitChance = plantOnHitChance;
        this.canDropBerryOnReceiveHit = canDropBerryOnReceiveHit;
        this.canPlantBerryOnDeath = canPlantBerryOnDeath;
    }
}

