/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.EntityAttributeUtils;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class BerserkAspectHandler
implements IAspectHandler {
    private static final UUID SPEED_MODIFIER_IDENTIFIER = UUID.fromString("bf49424e-7d06-44de-b533-ec6830aa1d01");
    private static final UUID DAMAGE_MODIFIER_IDENTIFIER = UUID.fromString("7e1dce9e-e75a-47c1-8f71-28a9dd62a342");
    private float damageIncreasePerLossHealth = 1.0f;
    private float speedIncreasePerLossHealth = 1.0f;

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        if (!victim.func_70089_S() || victim.func_110143_aJ() < amount) {
            return;
        }
        float lossHealthPercent = 1.0f - (victim.func_110143_aJ() - amount) / victim.func_110138_aP();
        float damageIncrease = lossHealthPercent * this.damageIncreasePerLossHealth;
        float speedIncrease = lossHealthPercent * this.speedIncreasePerLossHealth;
        EntityAttributeUtils.ApplyAttributeModifier(victim, Attributes.field_233821_d_, SPEED_MODIFIER_IDENTIFIER, speedIncrease, AttributeModifier.Operation.MULTIPLY_TOTAL, "Berserk speed increase");
        EntityAttributeUtils.ApplyAttributeModifier(victim, Attributes.field_233823_f_, DAMAGE_MODIFIER_IDENTIFIER, damageIncrease, AttributeModifier.Operation.MULTIPLY_TOTAL, "Berserk damage increase");
    }

    public void setDamageIncreaseValue(float value) {
        this.damageIncreasePerLossHealth = value;
    }

    public void setSpeedIncreaseValue(float value) {
        this.speedIncreasePerLossHealth = value;
    }
}

