/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.util.Utils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class DamageTransferAspectHandler
implements IAspectHandler {
    private float range = 3.0f;
    private float transferPercent = 0.5f;

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        World world = victim.func_130014_f_();
        if (world.field_72995_K || amount <= 0.0f) {
            return;
        }
        List<MobEntity> mobEntityList = Utils.findNearbyMobs((Entity)victim, victim.func_130014_f_(), this.range);
        float amountToTransfer = amount * this.transferPercent;
        boolean isDamageTransferred = false;
        for (MobEntity mob : mobEntityList) {
            boolean hasDamageTransfer;
            if (!mob.func_70089_S() || mob.func_110124_au().equals(victim.func_110124_au()) || (hasDamageTransfer = mob.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).map(IAspectMob::getAspectCodes).filter(list -> list.contains((Object)AspectEnum.DAMAGE_TRANSFER)).isPresent())) continue;
            mob.func_70097_a(damageSource, amountToTransfer);
            isDamageTransferred = true;
            break;
        }
        if (isDamageTransferred) {
            evt.setAmount(amount - amountToTransfer);
        }
    }

    public void setConfig(float range, float transferPercent) {
        this.range = range;
        this.transferPercent = transferPercent;
    }
}

