/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.CustomDamageSource;
import com.mz.mobaspects.entity.OverloadCrystalEntity;
import com.mz.mobaspects.util.Utils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class OverloadAspectHandler
implements IAspectHandler {
    private int maxHits = 4;
    private int ticksToReduceHitCount = 50;
    private int ticksBeforeExplosion = 100;
    private float explosionRadius = 5.0f;
    private boolean countHitsFromPlayerOnly = true;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        MobEntity mob = (MobEntity)entity;
        OverloadCrystalEntity followerEntity = new OverloadCrystalEntity(entity.field_70170_p, mob);
        followerEntity.setConfig(this.maxHits, this.ticksToReduceHitCount, this.ticksBeforeExplosion, this.explosionRadius);
        Utils.queueFollowerEntitySpawn(entity.field_70170_p, followerEntity, (MobEntity)entity);
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        if (CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(evt.getSource())) {
            return;
        }
        if (this.countHitsFromPlayerOnly && !(evt.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.getAspectFollowers().stream().filter(followerEntity -> followerEntity instanceof OverloadCrystalEntity).findFirst().map(followerEntity -> (OverloadCrystalEntity)((Object)((Object)followerEntity))).ifPresent(OverloadCrystalEntity::takeHit));
    }

    public void setConfig(int maxHits, int ticksToReduceHitCount, int ticksBeforeExplosion, float explosionRadius, boolean countHitsFromPlayerOnly) {
        this.maxHits = maxHits;
        this.ticksToReduceHitCount = ticksToReduceHitCount;
        this.ticksBeforeExplosion = ticksBeforeExplosion;
        this.explosionRadius = explosionRadius;
        this.countHitsFromPlayerOnly = countHitsFromPlayerOnly;
    }
}

